<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use App\Libraries\BulkRegistrationService;

class ProcessBulkRegistrations extends BaseCommand
{
    /**
     * The Command's Group
     *
     * @var string
     */
    protected $group = 'Bulk';

    /**
     * The Command's Name
     *
     * @var string
     */
    protected $name = 'bulk:process';

    /**
     * The Command's Description
     *
     * @var string
     */
    protected $description = 'Processes pending bulk registration validations.';

    /**
     * The Command's Usage
     *
     * @var string
     */
    protected $usage = 'command:name [arguments] [options]';

    /**
     * The Command's Arguments
     *
     * @var array
     */
    protected $arguments = [];

    /**
     * The Command's Options
     *
     * @var array
     */
    protected $options = [];

    /**
     * Actually execute a command.
     *
     * @param array $params
     */
    public function run(array $params)
    {
        CLI::write('Starting bulk registration processing...', 'cyan');
        
        $service = new BulkRegistrationService();
        $result = $service->validatePendingParticipants();

        if ($result['processed_count'] > 0) {
            CLI::write("Processed {$result['processed_count']} participants.", 'white');
            CLI::write("Valid: {$result['valid_count']}", 'green');
            CLI::write("Invalid: {$result['invalid_count']}", 'red');
        } else {
            CLI::write('No pending participants to process.', 'yellow');
        }
        
        CLI::write('Processing complete.', 'cyan');
    }
}
