<?php

namespace App\Models;

use CodeIgniter\Model;

class BulkTemporaryParticipantModel extends Model
{
    protected $table            = 'bulk_temporary_participants';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object'; 
    protected $useSoftDeletes   = true; 
    protected $protectFields    = true;

    protected $allowedFields    = [
        'bulk_transaction_id',
        'name',
        'phone_number',
        'kta_number',
        'church_id',
        'church_name',
        'birth_date',
        'email',
        'gender',
        'process_status',
        'process_result',
        'excel_row'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';
}