<?php

namespace App\Models;

use CodeIgniter\Model;

class BulkTransactionModel extends Model
{
    protected $table            = 'bulk_transactions';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object'; 
    protected $useSoftDeletes   = true; 
    protected $protectFields    = true;


    protected $allowedFields    = [
        'event_id',
        'user_id',
        'church_id',
        'transaction_date',
        'payment_type',
        'invoice_number',
        'event_package_id',
        'excel_path',
        'description',
        'total_quantity',
        'total_amount',
        'process_status',
        'process_result',
        'created_by',
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';


    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
}