<?php
// app/Models/VerificationTokenModel.php
namespace App\Models;

use CodeIgniter\Model;

class VerificationTokenModel extends Model
{
    protected $table            = 'user_verification_tokens';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';

    protected $allowedFields    = ['user_id', 'token', 'medium', 'expires_at', 'created_at', 'updated_at'];

    protected $useTimestamps    = true;
    protected $createdField     = 'created_at';
    protected $updatedField     = 'updated_at';

    // Kita tidak perlu hash token ini, karena kita akan mencocokkannya langsung.
    // Keamanan datang dari keacakan dan masa berlakunya yang singkat.
}