<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold text-gray-800"><?= lang('Admin/BulkTransactions.pageHeader') ?></h2>
        <?php if(has_permission('create-bulk-transaction')): ?>
            <a href="<?= route_to('admin.bulk.new') ?>" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 shadow-sm">
                <?= lang('Admin/BulkTransactions.btnNew') ?>
            </a>
        <?php endif; ?>
    </div>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <div class="overflow-x-auto bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Event</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Uploaded By</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Qty</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if (!empty($uploads)): foreach($uploads as $upload): ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= date('d M Y, H:i', strtotime($upload->created_at)) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?= esc($upload->event_name) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($upload->user_name) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($upload->total_quantity) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                <?= $upload->process_status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' ?>">
                                <?= esc(ucfirst(str_replace('_', ' ', $upload->process_status))) ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <a href="<?= route_to('admin.bulk.show',$upload->id) ?>" class="text-indigo-600 hover:underline">View Result</a>
                        </td>
                    </tr>
                <?php endforeach; else: ?>
                    <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No bulk uploads found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="mt-6">
        <?= $pager->links('default', 'tailwind') ?>
    </div>
<?= $this->endSection() ?>