<?= csrf_field() ?>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6" x-data="{ fieldType: '<?= old('type', $field->type ?? 'text') ?>' }">
    <div class="md:col-span-2">
        <label for="label" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.fieldLabelLabel') ?></label>
        <input type="text" name="label" id="label" value="<?= old('label', $field->label ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.labelHelp') ?></p>
    </div>
    <div>
        <label for="field_key" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.fieldLabelKey') ?></label>
        <input type="text" name="field_key" id="field_key" value="<?= old('field_key', $field->field_key ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required <?= isset($field) ? 'readonly class="bg-gray-200 cursor-not-allowed"' : '' ?>>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.keyHelp') ?></p>
    </div>
    <div>
        <label for="type" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.fieldLabelType') ?></label>
        <select name="type" id="type" x-model="fieldType" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5">
            <option value="text" <?= (old('type', $field->type ?? '') == 'text') ? 'selected' : '' ?>>Text</option>
            <option value="number" <?= (old('type', $field->type ?? '') == 'number') ? 'selected' : '' ?>>Number</option>
            <option value="date" <?= (old('type', $field->type ?? '') == 'date') ? 'selected' : '' ?>>Date</option>
            <option value="email" <?= (old('type', $field->type ?? '') == 'email') ? 'selected' : '' ?>>Email</option>
            <option value="select" <?= (old('type', $field->type ?? '') == 'select') ? 'selected' : '' ?>>Select</option>
        </select>
    </div>
    
    <div class="md:col-span-2" x-show="fieldType === 'select'" x-cloak>
        <label for="options" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.fieldLabelOptions') ?></label>
        <textarea name="options" id="options" rows="4" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5"><?= old('options', isset($field->options) ? implode("\n", json_decode($field->options, true)) : '') ?></textarea>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.optionsHelp') ?></p>
    </div>
    <div x-show="fieldType === 'select'" x-cloak>
        <label class="flex items-center mt-2">
            <input type="checkbox" name="is_multiple" value="1" class="h-4 w-4 text-indigo-600 border-gray-300 rounded" <?= old('is_multiple', $field->is_multiple ?? false) ? 'checked' : '' ?>>
            <span class="ml-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.fieldLabelMultiple') ?></span>
        </label>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.multipleHelp') ?></p>
    </div>

    <div>
        <label class="flex items-center mt-2">
            <input type="checkbox" name="is_required" value="1" class="h-4 w-4 text-indigo-600 border-gray-300 rounded" <?= old('is_required', $field->is_required ?? true) ? 'checked' : '' ?>>
            <span class="ml-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.fieldLabelRequired') ?></span>
        </label>
    </div>
    <div>
        <label for="sort_order" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.fieldLabelSort') ?></label>
        <input type="number" name="sort_order" id="sort_order" value="<?= old('sort_order', $field->sort_order ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required min="0">
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.sortHelp') ?></p>
    </div>
</div>