<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
<div class="bg-white p-8 rounded-lg shadow-md max-w-4xl mx-auto">
    <h2 class="text-2xl font-semibold mb-6 border-b pb-4"><?= lang('Admin/Events.newPackage') ?> for "<?= esc($event->name) ?>"</h2>
    <?= $this->include('backend/layouts/_notifications') ?>
    <?= form_open(route_to('admin.events.packages.create', $event->id)) ?>
        <div class="p-6 rounded-lg">
            <?= $this->include('backend/events/packages/_form') ?>
        </div>
        <div class="mt-6 flex justify-end gap-4 border-t pt-6">
            <a href="<?= route_to('admin.events.show', $event->id) ?>" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-md hover:bg-gray-300">Cancel</a>
            <button type="submit" class="bg-indigo-600 text-white font-bold px-4 py-2 rounded-md hover:bg-indigo-700"><?= lang('Admin/Events.btnSavePackage') ?></button>
        </div>
    <?= form_close() ?>
</div>
<?= $this->endSection() ?>