<?= csrf_field() ?>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div class="md:col-span-2">
        <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pmLabelName') ?></label>
        <input type="text" name="name" id="name" value="<?= old('name', $method->name ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.pmNameHelp') ?></p>
    </div>
    
    <div>
        <label for="method" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pmLabelMethod') ?></label>
        <select name="method" id="method" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
            <option value="cash" <?= (old('method', $method->method ?? '') == 'cash') ? 'selected' : '' ?>>Cash</option>
            <option value="va" <?= (old('method', $method->method ?? '') == 'va') ? 'selected' : '' ?>>Virtual Account (VA)</option>
            <option value="transfer" <?= (old('method', $method->method ?? '') == 'transfer') ? 'selected' : '' ?>>Transfer</option>
        </select>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.pmMethodHelp') ?></p>
    </div>

    <div>
        <label for="fee" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pmLabelFee') ?></label>
        <input type="number" name="fee" id="fee" value="<?= old('fee', $method->fee ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required min="0" step="1">
    </div>

    <div class="md:col-span-2">
        <label class="flex items-center">
            <input type="checkbox" name="is_active" value="1" class="h-4 w-4 text-indigo-600 border-gray-300 rounded" <?= old('is_active', $method->is_active ?? true) ? 'checked' : '' ?>>
            <span class="ml-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pmLabelIsActive') ?></span>
        </label>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.pmActiveHelp') ?></p>
    </div>
</div>