<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold"><?= lang('Admin/Events.manageEvent', [esc($event->name)]) ?></h2>
        <a href="<?= route_to('admin.events.index') ?>" class="text-sm text-gray-600 hover:underline">← Back to Event List</a>
    </div>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Kolom Kiri: Detail Utama & Aksi -->
        <div class="lg:col-span-1">
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h3 class="text-xl font-semibold mb-2"><?= lang('Admin/Events.hubDetails') ?></h3>
                <div class="space-y-2 text-sm text-gray-600">
                    <p><strong>Status:</strong> <?= $event->is_active ? '<span class="text-green-600">Active</span>' : '<span class="text-gray-500">Inactive</span>' ?></p>
                    <p><strong>Dates:</strong> <?= date('d M Y', strtotime($event->start_date)) ?> to <?= date('d M Y', strtotime($event->end_date)) ?></p>
                    <p><strong>Church:</strong> <?= $event->church_id ? 'Specific Church' : lang('Admin/Events.allChurches') ?></p>
                    <p><strong>Quota:</strong> <?= $event->quota > 0 ? "{$event->used_quota} / {$event->quota}" : 'Unlimited' ?></p>
                </div>
                <div class="mt-4 pt-4 border-t">
                    <a href="<?= route_to('admin.events.edit', $event->id) ?>" class="w-full text-center inline-block bg-indigo-100 text-indigo-700 px-4 py-2 rounded-md hover:bg-indigo-200 font-semibold"><?= lang('Admin/Events.btnEditDetails') ?></a>
                </div>
            </div>
        </div>

        <!-- Kolom Kanan: Item-item Terkait -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Card untuk Packages -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <div class="flex justify-between items-center mb-4">
                    <div>
                        <h3 class="text-xl font-semibold"><?= lang('Admin/Events.hubPackages') ?></h3>
                        <p class="text-sm text-gray-500">Manage ticket types for this event.</p>
                    </div>
                    <a href="<?= route_to('admin.events.packages.new', $event->id) ?>" class="bg-indigo-600 text-white px-3 py-1 rounded-md text-sm font-medium hover:bg-indigo-700">
                        <?= lang('Admin/Events.btnAddPackage') ?>
                    </a>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <!-- Tabel header -->
                        <tbody class="divide-y">
                            <?php if(!empty($packages)): foreach($packages as $pkg): ?>
                                <tr>
                                    <td class="py-2"><?= esc($pkg->name) ?></td>
                                    <td class="py-2">Rp <?= number_format($pkg->price) ?></td>
                                    <td class="py-2">Quota: <?= $pkg->quota > 0 ? "{$pkg->used_quota} / {$pkg->quota}" : 'Unlimited' ?></td>
                                    <td class="py-2 text-right">
                                        <a href="<?= route_to('admin.events.packages.edit', $event->id, $pkg->id) ?>" class="text-indigo-600">Edit</a>
                                        <?= form_open(route_to('admin.events.packages.delete', $event->id, $pkg->id), ['class' => 'inline ml-2', 'onsubmit' => "return confirm('Are you sure?')"]) ?>
                                            <button type="submit" class="text-red-600">Delete</button>
                                        <?= form_close() ?>
                                    </td>
                                </tr>
                            <?php endforeach; else: ?>
                                <tr><td colspan="4" class="py-4 text-center text-gray-500"><?= lang('Admin/Events.noPackages') ?></td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Card untuk Payment Methods -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <div class="flex justify-between items-center mb-4">
                    <div>
                        <h3 class="text-xl font-semibold"><?= lang('Admin/Events.hubPayments') ?></h3>
                        <p class="text-sm text-gray-500">Manage available payment methods.</p>
                    </div>
                    <a href="<?= route_to('admin.events.payment_method.new', $event->id) ?>" class="bg-indigo-600 text-white px-3 py-1 rounded-md text-sm font-medium hover:bg-indigo-700">
                        <?= lang('Admin/Events.btnAddPayment') ?>
                    </a>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="py-2 px-3 text-left">Display Name</th>
                                <th class="py-2 px-3 text-left">Type</th>
                                <th class="py-2 px-3 text-left">Fee</th>
                                <th class="py-2 px-3 text-left">Status</th>
                                <th class="py-2 px-3 text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y">
                            <?php if(!empty($paymentMethods)): foreach($paymentMethods as $pm): ?>
                                <tr>
                                    <td class="py-2 px-3"><?= esc($pm->name) ?></td>
                                    <td class="py-2 px-3"><span class="font-mono text-xs bg-gray-200 text-gray-700 px-1 py-0.5 rounded"><?= esc($pm->method) ?></span></td>
                                    <td class="py-2 px-3">Rp <?= number_format($pm->fee) ?></td>
                                    <td class="py-2 px-3"><?= $pm->is_active ? '<span class="text-green-600">Active</span>' : '<span class="text-gray-500">Inactive</span>' ?></td>
                                    <td class="py-2 px-3 text-right">
                                        <a href="<?= route_to('admin.events.payment_method.edit', $event->id, $pm->id) ?>" class="text-indigo-600 hover:underline">Edit</a>
                                        <?= form_open(route_to('admin.events.payment_method.delete', $event->id, $pm->id), ['class' => 'inline ml-2', 'onsubmit' => "return confirm('Are you sure?')"]) ?>
                                            <button type="submit" class="text-red-600 hover:underline">Delete</button>
                                        <?= form_close() ?>
                                    </td>
                                </tr>
                            <?php endforeach; else: ?>
                                <tr><td colspan="5" class="py-4 text-center text-gray-500"><?= lang('Admin/Events.noPayments') ?></td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Card untuk Custom Fields -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <div class="flex justify-between items-center mb-4">
                    <div>
                        <h3 class="text-xl font-semibold"><?= lang('Admin/Events.hubFields') ?></h3>
                        <p class="text-sm text-gray-500">Manage additional fields for participant registration.</p>
                    </div>
                    <a href="<?= route_to('admin.events.event_fields.new', $event->id) ?>" class="bg-indigo-600 text-white px-3 py-1 rounded-md text-sm font-medium hover:bg-indigo-700">
                        <?= lang('Admin/Events.btnAddField') ?>
                    </a>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="py-2 px-3 text-left">Label</th>
                                <th class="py-2 px-3 text-left">Type</th>
                                <th class="py-2 px-3 text-left">Required</th>
                                <th class="py-2 px-3 text-left">Sort</th>
                                <th class="py-2 px-3 text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y">
                            <?php if(!empty($customFields)): foreach($customFields as $field): ?>
                                <tr>
                                    <td class="py-2 px-3"><?= esc($field->label) ?></td>
                                    <td class="py-2 px-3"><span class="font-mono text-xs bg-gray-200 text-gray-700 px-1 py-0.5 rounded"><?= esc($field->type) ?></span></td>
                                    <td class="py-2 px-3"><?= $field->is_required ? '<span class="text-green-600">Yes</span>' : '<span class="text-gray-500">No</span>' ?></td>
                                    <td class="py-2 px-3"><?= esc($field->sort_order) ?></td>
                                    <td class="py-2 px-3 text-right">
                                        <a href="<?= route_to('admin.events.event_fields.edit', $event->id, $field->id) ?>" class="text-indigo-600 hover:underline">Edit</a>
                                        <?= form_open(route_to('admin.events.event_fields.delete', $event->id, $field->id), ['class' => 'inline ml-2', 'onsubmit' => "return confirm('".lang('Admin/Events.fieldDeleteConfirm')."');"]) ?>
                                            <button type="submit" class="text-red-600 hover:underline">Delete</button>
                                        <?= form_close() ?>
                                    </td>
                                </tr>
                            <?php endforeach; else: ?>
                                <tr><td colspan="5" class="py-4 text-center text-gray-500"><?= lang('Admin/Events.noFields') ?></td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            
        </div>
    </div>
<?= $this->endSection() ?>