<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold text-gray-800"><?= lang('Admin/Promotions.pageHeader') ?></h2>
        <?php if(has_permission('create-promotion')): ?>
            <a href="<?= route_to('admin.promotions.new') ?>" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 shadow-sm">
                <?= lang('Admin/Promotions.btnNew') ?>
            </a>
        <?php endif; ?>
    </div>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <!-- Anda bisa menambahkan form filter di sini nanti jika diperlukan -->

    <div class="overflow-x-auto bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Promotions.colName') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Promotions.colEvent') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Promotions.colDiscount') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Promotions.colDates') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Promotions.colQuota') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Promotions.colStatus') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Promotions.colActions') ?></th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if (!empty($promotions)): foreach($promotions as $promo): ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                            <?= esc($promo->name) ?>
                            <div class="text-xs font-mono text-gray-500 bg-gray-100 inline-block px-1 rounded"><?= esc($promo->code) ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($promo->event_name) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-800">
                            <?php if($promo->discount_amount > 0): ?>
                                Rp <?= number_format($promo->discount_amount) ?>
                            <?php else: ?>
                                <?= $promo->discount_percent ?>%
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= date('d M Y', strtotime($promo->start_date)) ?> - <?= date('d M Y', strtotime($promo->end_date)) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= $promo->quota > 0 ? "{$promo->used_quota} / {$promo->quota}" : 'Unlimited' ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                <?= $promo->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
                                <?= $promo->is_active ? lang('Admin/Promotions.statusActive') : lang('Admin/Promotions.statusInactive') ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <?php if(has_permission('edit-promotion')): ?>
                                <a href="<?= route_to('admin.promotions.edit', $promo->id) ?>" class="text-indigo-600 hover:underline">Edit</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; else: ?>
                    <tr><td colspan="7" class="px-6 py-4 text-center text-gray-500"><?= lang('Admin/Promotions.noResults') ?></td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="mt-6">
        <?= $pager->links('default', 'tailwind') ?>
    </div>
<?= $this->endSection() ?>