<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($subject) ?></title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
            margin: 0;
            padding: 0;
            width: 100% !important;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
    </style>
</head>
<body style="background-color: #edf2f7; margin: 0; padding: 0;">
    <table width="100%" cellpadding="0" cellspacing="0" role="presentation" style="background-color: #edf2f7; padding: 40px 20px;">
        <tr>
            <td align="center">
                <!-- Logo/Header -->
                <table width="100%" cellpadding="0" cellspacing="0" role="presentation" style="max-width: 600px; margin: 0 auto;">
                    <tr>
                        <td style="padding: 25px 0; text-align: center;">
                            <a href="<?= site_url() ?>" style="font-size: 24px; font-weight: bold; color: #4f46e5; text-decoration: none;">
                                <?= getenv('app.name') ?? 'Your Application' ?>
                            </a>
                        </td>
                    </tr>
                </table>

                <!-- Konten Utama -->
                <table width="100%" cellpadding="0" cellspacing="0" role="presentation" style="max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 8px; border: 1px solid #e8e5ef;">
                    <tr>
                        <td style="padding: 40px;">
                            <h1 style="color: #3d4852; font-size: 18px; font-weight: bold; margin-top: 0;"><?= esc($greeting) ?></h1>
                            <p style="font-size: 16px; line-height: 1.5em; margin-top: 0; color: #3d4852;"><?= $message // Asumsi message sudah aman dari service ?></p>
                            
                            <!-- Tabel untuk Tombol Aksi -->
                            <table align="center" width="100%" cellpadding="0" cellspacing="0" role="presentation" style="margin: 30px auto; text-align: center;">
                                <tr>
                                    <td align="center">
                                        <!-- Tombol yang Dibuat dengan Tabel -->
                                        <table width="100%" border="0" cellspacing="0" cellpadding="0" role="presentation">
                                            <tr>
                                                <td align="center">
                                                    <div>
                                                        <!--[if mso]>
                                                        <v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="<?= $verificationLink ?>" style="height:45px;v-text-anchor:middle;width:200px;" arcsize="10%" strokecolor="#4f46e5" fillcolor="#4f46e5">
                                                            <w:anchorlock/>
                                                            <center style="color:#ffffff;font-family:sans-serif;font-size:16px;font-weight:bold;">
                                                                <?= esc($buttonText) ?>
                                                            </center>
                                                        </v:roundrect>
                                                        <![endif]-->
                                                        <a href="<?= $verificationLink ?>" target="_blank" style="background-color:#4f46e5;border-radius:5px;color:#ffffff;display:inline-block;font-family:sans-serif;font-size:16px;font-weight:bold;line-height:45px;text-align:center;text-decoration:none;width:200px;-webkit-text-size-adjust:none;mso-hide:all;"><?= esc($buttonText) ?></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            
                            <p style="font-size: 16px; line-height: 1.5em; margin-top: 0; color: #3d4852;"><?= esc($backupText) ?></p>
                            <p style="font-size: 12px; line-height: 1.5em; margin-top: 0;">
                                <a href="<?= $verificationLink ?>" target="_blank" style="color: #4f46e5; word-break: break-all;"><?= $verificationLink ?></a>
                            </p>
                            
                            <hr style="border: none; border-top: 1px solid #e8e5ef; margin: 30px 0;">

                            <p style="font-size: 12px; line-height: 1.5em; margin-top: 0; color: #718096;"><?= esc($disclaimer) ?></p>
                        </td>
                    </tr>
                </table>

                <!-- Footer -->
                <table width="100%" cellpadding="0" cellspacing="0" role="presentation" style="max-width: 600px; margin: 0 auto;">
                    <tr>
                        <td style="padding: 25px; text-align: center;">
                            <p style="font-size: 12px; color: #718096;">© <?= date('Y') ?> <?= getenv('app.name') ?>. All rights reserved.</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>