<!-- File: app/Views/frontend/components/_notifications.php -->

<?php
// Ambil semua error dari session flash data
$errors = session()->getFlashdata('errors');
?>

<!-- Menampilkan pesan sukses -->
<?php if (session()->getFlashdata('success')) : ?>
    <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert">
        <p class="font-bold">Success</p>
        <p><?= session()->getFlashdata('success') ?></p>
    </div>
<?php endif; ?>

<!-- Menampilkan pesan error umum (dari ->with('error', ...)) -->
<?php if (session()->getFlashdata('error')) : ?>
    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
        <p class="font-bold">Error</p>
        <p><?= session()->getFlashdata('error') ?></p>
    </div>
<?php endif; ?>

<!-- MENAMPILKAN DAFTAR ERROR VALIDASI (INI YANG PENTING) -->
<?php if (!empty($errors)): ?>
    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
        <p class="font-bold">Validation Errors</p>
        <ul class="list-disc ml-5 mt-2">
            <?php foreach ($errors as $error) : ?>
                <li><?= esc($error) ?></li>
            <?php endforeach ?>
        </ul>
    </div>
<?php endif; ?>