<?php
// app/Language/en/Transaction.php

return [
    // Halaman Awal (new.php)
    'start_title'           => 'Start New Transaction',
    'start_subtitle'        => 'Please select the event you want to register for.',
    'register_now_button'   => 'Register Now →',
    'no_active_events'      => 'There are currently no active events available for registration.',
    'error_event_not_found' => 'The selected event is not valid or no longer active.',

    // Halaman Form Peserta (new_step2.php)
    'form_title'              => 'Registration for {0}', // {0} = nama event
    'step1_title'             => 'Participant Details',
    'step2_title'             => 'Review & Payment',
    'button_add_participant'  => '+ Add Another Participant',
    'max_participant_note'    => 'You can add up to 5 participants per transaction.',
    'participant_label'       => 'Participant {0}',
    'button_remove'           => 'Remove Participant',
    'participant_package_label' => 'Select Package',

    // Form Fields & Placeholders
    'field_fullname'          => 'Full Name',
    'placeholder_fullname'    => 'Enter participant’s full name',
    'field_phone'             => 'Phone Number',
    'placeholder_phone'       => 'e.g., +628123456789',
    'field_email'             => 'Email',
    'placeholder_email'       => 'participant@email.com',
    'field_gender'            => 'Gender',
    'option_male'             => 'Male',
    'option_female'           => 'Female',
    'field_kta'               => 'KTA',
    'placeholder_kta'         => 'Enter KTA number if available',
    'field_birthdate'         => 'Date of Birth',
    'kta_required_note'       => 'This package requires a valid KTA. Please fill it in.',
    'additional_info'         => 'Additional Information',
    'option_choose_package'   => '-- Choose a package for this participant --',
    'option_choose_payment'   => '-- Select a Payment Method --',
    'field_church'            => 'Church',
    'option_choose_church'    => '-- Select your church --',
    'option_other_church'     => 'Other Church (Not on the list)',
    'field_other_church_name' => 'Other Church Name',
    'placeholder_other_church'=> 'Please specify your church name',

    // Bagian Review & Pembayaran
    'summary_subtotal'        => 'Subtotal',
    'summary_handling_fee'    => 'Handling Fee',
    'summary_total'           => 'Total Amount',
    'field_payment_method'    => 'Payment Method',
    'button_process'          => 'Process Transaction',

    // Bagian Promo
    'field_promo_code'        => 'Promo Code',
    'placeholder_promo_code'  => 'Enter promo code',
    'btn_apply_promo'         => 'Apply',
    'summary_discount'        => 'Discount',
    'promo_applied_success'   => 'Promo code applied successfully!',
    'error_promo_not_found'   => 'Promo code not found or has expired.',
    'error_promo_min_qty'     => 'Promo code requires a minimum of {0} participants.',
    'error_promo_max_qty'     => 'Promo code can only be used for exactly {0} participants.',
    'error_promo_min_amount'  => 'Promo code requires a minimum subtotal of {0}.',
    'error_promo_max_amount'  => 'Promo code cannot be used for a subtotal exceeding {0}.',
    'error_promo_quota_full'  => 'This promo code has reached its usage limit.',

    // Halaman Detail (show.php)
    'error_transaction_not_found' => 'The requested transaction could not be found.',

    // Pesan dari Controller
    'error_processing'        => 'Your previous transaction is still being processed. Please wait.',
    'error_db_save'           => 'Failed to save transaction data due to a database error.',
    'error_unexpected'        => 'An unexpected error occurred. Please try again.',
    'error_payment_init'      => 'Failed to initiate payment due to incomplete data.',
    'error_payment_session'   => 'Could not create payment session: {0}',
    'error_payment_url'       => 'Could not retrieve payment URL: {0}',
    'error_payment_connect'   => 'Could not connect to the payment service. Please try again later.',
    'success_created'         => 'Transaction created successfully! Please complete your payment.',

    // PDF
    'pdf_eticket_title'         => 'E-Ticket - {0}', // {0} = Nomor Invoice
    'pdf_eticket_heading'       => 'E-Ticket',
    'pdf_invoice_label'         => 'Invoice',
    'pdf_transaction_details'   => 'Transaction Details',
    'pdf_event_label'           => 'Event:',
    'pdf_date_label'            => 'Date:',
    'pdf_amount_label'          => 'Total Amount:',
    'pdf_status_label'          => 'Status:',
    'pdf_participant_tickets'   => 'Participant Tickets',
    'pdf_qr_not_available'      => 'QR Code Not Available',
    'pdf_error_not_paid'        => 'PDF can only be downloaded for paid transactions.',


];