<?php
// app/Libraries/PdfService.php
namespace App\Libraries;

// ... (use statements tetap sama)
use Dompdf\Dompdf;
use Dompdf\Options;
use App\Libraries\TransactionService;

class PdfService
{
    protected string $pdfStoragePath;

    public function __construct()
    {
        // Definisikan path folder penyimpanan PDF
        $this->pdfStoragePath = WRITEPATH . 'etickets' . DIRECTORY_SEPARATOR;

        // Pastikan direktori ada
        if (!is_dir($this->pdfStoragePath)) {
            mkdir($this->pdfStoragePath, 0775, true);
        }
    }


    public function createTicketPdf(array $data): ?string
    {
        try {
            helper('general');
            $sanitizedInvoice = sanitize_filename($data['transaction']->invoice_number);
            $timestamp = date('Ymd-His');
            $filename = "e-ticket_{$sanitizedInvoice}_{$timestamp}.pdf";
            $fullPath = $this->pdfStoragePath . $filename;
            
            $options = new Options();
            $options->set('isRemoteEnabled', true);
            $options->set('defaultFont', 'sans-serif');
            
            $dompdf = new Dompdf($options);
            $html = view('pdf/eticket', $data);
            $dompdf->loadHtml($html);
            $dompdf->setPaper('A4', 'portrait');
            $dompdf->render();

            // Simpan PDF ke file di server
            file_put_contents($fullPath, $dompdf->output());

            return $fullPath;

        } catch (\Exception $e) {
            log_message('error', '[PdfService] Failed to create PDF file: ' . $e->getMessage());
            return null;
        }
    }


    public function streamTicket(string $transactionUuid, ?int $requesterId)
    {
        $transactionService = new TransactionService();
        $transactionData = $transactionService->getTransactionData($transactionUuid, $requesterId);

        if (!$transactionData) {
            return ['error' => lang('Transaction.error_transaction_not_found')];
        }
        if (isset($transactionData['error'])) {
            return $transactionData;
        }

        // Render PDF ke browser untuk di-download
        $dompdf = new Dompdf();
        $html = view('pdf/eticket', $transactionData);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();
        
        helper('general');
        $sanitizedInvoice = sanitize_filename($transactionData['transaction']->invoice_number);
        $timestamp = date('Ymd-His');
        $filename = "e-ticket_{$sanitizedInvoice}_{$timestamp}.pdf";
        $fullPath = $this->pdfStoragePath . $filename;
        $dompdf->stream($filename, ['Attachment' => 1]);
        exit();
    }


    public function streamSingleTicket(array $data)
    {
        $filename = 'e-ticket-' . sanitize_filename($data['participant']->name) . '.pdf';
        $html = view('pdf/single_eticket', $data);

        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper([0, 0, 300, 450]); // Atur ukuran kertas kustom (lebar, tinggi)
        $dompdf->render();
        $dompdf->stream($filename, ['Attachment' => 1]);
        exit();
    }
    
    
}