<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold"><?= lang('Admin/Admins.pageHeader') ?></h2>
        <a href="<?= route_to('admin.admins.new') ?>" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700"><?= lang('Admin/Admins.btnNew') ?></a>
    </div>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <div class="overflow-x-auto bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Admins.colName') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Admins.colEmail') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Admins.colRole') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Admins.colActions') ?></th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if (!empty($admins)): ?>
                    <?php foreach($admins as $admin): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?= esc($admin->name) ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($admin->email) ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($admin->role_name) ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium flex items-center gap-4">
                                <a href="<?= route_to('admin.admins.edit', $admin->id) ?>" class="text-indigo-600 hover:underline">Edit</a>
                                
                                <!-- Form untuk Delete -->
                                <?= form_open(route_to('admin.admins.delete', $admin->id), ['onsubmit' => "return confirm('".lang('Admin/Admins.deleteConfirm')."');"]) ?>
                                    <button type="submit" class="text-red-600 hover:underline disabled:text-gray-400 disabled:cursor-not-allowed" 
                                            <?= ($admin->id == session()->get('user_id')) ? 'disabled' : '' ?>>
                                        Delete
                                    </button>
                                <?= form_close() ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="4" class="px-6 py-4 text-center text-gray-500"><?= lang('Admin/Admins.noResults') ?></td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-6"><?= $pager->links('default', 'tailwind') ?></div>
<?= $this->endSection() ?>