<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= lang('Admin/Login.pageTitle') ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="flex items-center justify-center min-h-screen">
        <div class="w-full max-w-sm p-8 space-y-6 bg-white rounded-lg shadow-xl">
            <h1 class="text-2xl font-bold text-center text-gray-800"><?= lang('Admin/Login.mainHeading') ?></h1>
            <p class="text-center text-gray-500"><?= lang('Admin/Login.subHeading') ?></p>
            
            <!-- Notifikasi -->
            <?= service('session')->getFlashdata('error') ? '<div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4" role="alert"><p>'.service('session')->getFlashdata('error').'</p></div>' : '' ?>
            <?= service('session')->getFlashdata('success') ? '<div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4" role="alert"><p>'.service('session')->getFlashdata('success').'</p></div>' : '' ?>

            <?= form_open(route_to('admin.login.attempt')) ?>
                <?= csrf_field() ?>

                <div class="space-y-4">
                    <div>
                        <label for="email" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Login.labelEmail') ?></label>
                        <input type="email" name="email" id="email" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" value="<?= old('email') ?>" required>
                    </div>

                    <div>
                        <label for="password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Login.labelPassword') ?></label>
                        <input type="password" name="password" id="password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                    </div>
                </div>

                <div class="pt-6">
                     <button type="submit" class="w-full text-white bg-indigo-600 hover:bg-indigo-700 focus:ring-4 focus:outline-none focus:ring-indigo-300 font-medium rounded-lg text-sm px-5 py-3 text-center"><?= lang('Admin/Login.buttonLogin') ?></button>
                </div>
            <?= form_close() ?>
        </div>
    </div>
</body>
</html>