<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>

<div class="max-w-xl mx-auto">
    <div class="bg-white p-8 rounded-lg shadow-md">
        <h3 class="text-2xl font-semibold mb-6 border-b pb-4"><?= lang('Admin/Profile.changePassword') ?></h3>
        
        <?= $this->include('backend/layouts/_notifications') ?>

        <div x-data="{ isSubmitting: false }">
            <?= form_open(route_to('admin.profile.update_password'), ['@submit' => 'isSubmitting = true']) ?>
                <?= csrf_field() ?>
                <div class="space-y-4">
                    <div>
                        <label for="current_password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Profile.labelCurrentPass') ?></label>
                        <input type="password" name="current_password" id="current_password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                    </div>
                    <div>
                        <label for="new_password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Profile.labelNewPass') ?></label>
                        <input type="password" name="new_password" id="new_password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                    </div>
                    <div>
                        <label for="confirm_new_password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Profile.labelConfirmPass') ?></label>
                        <input type="password" name="confirm_new_password" id="confirm_new_password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                    </div>
                </div>
                <div class="mt-6">
                    <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center bg-indigo-600 hover:bg-indigo-700 text-white font-bold px-6 py-2 rounded-md disabled:bg-gray-400 disabled:cursor-wait" :disabled="isSubmitting">
                        <svg x-show="isSubmitting" class="animate-spin -ml-1 mr-3 h-5 w-5" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                        <span x-text="isSubmitting ? 'Updating...' : '<?= lang('Admin/Profile.btnUpdatePassword') ?>'"></span>
                    </button>
                </div>
            <?= form_close() ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>