<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-8" 
     x-data="{ 
         isUpdatingStatus: false,
         isResending: false, 
         isDownloading: false 
     }">
    
    <!-- Kolom Kiri: Detail Utama -->
    <div class="lg:col-span-2 space-y-8">

        <!-- Card: Ringkasan Transaksi -->
        <div class="bg-white p-6 rounded-lg shadow-md">
            <h3 class="text-xl font-semibold mb-4 border-b pb-2"><?= lang('Admin/Transactions.sectionTransaction') ?></h3>
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-6 gap-y-4 text-sm">
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldInvoice') ?>:</strong><br><?= esc($transaction->invoice_number) ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldDate') ?>:</strong><br><?= date('d M Y, H:i', strtotime($transaction->created_at)) ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldEvent') ?>:</strong><br><?= esc($event->name) ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldPaymentMethod') ?>:</strong><br><?= esc(ucwords(str_replace('_', ' ', $transaction->payment_type))) ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldSubtotal') ?>:</strong><br>Rp <?= number_format($transaction->subtotal, 0, ',', '.') ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldDiscount') ?>:</strong><br>Rp <?= number_format($transaction->total_discount, 0, ',', '.') ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldHandlingFee') ?>:</strong><br>Rp <?= number_format($transaction->handling_fee, 0, ',', '.') ?></div>
                <div class="text-lg"><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldTotal') ?>:</strong><br><span class="font-bold">Rp <?= number_format($transaction->total_amount, 0, ',', '.') ?></span></div>
            </div>
        </div>

        <!-- Card: Detail User (Pendaftar) -->
        <div class="bg-white p-6 rounded-lg shadow-md">
            <h3 class="text-xl font-semibold mb-4 border-b pb-2"><?= lang('Admin/Transactions.sectionUser') ?></h3>
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-6 gap-y-4 text-sm">
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldName') ?>:</strong><br><?= esc($user->name) ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldEmail') ?>:</strong><br><?= esc($user->email) ?></div>
                <div><strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.fieldPhone') ?>:</strong><br>
                    <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $user->phone_number) ?>" target="_blank" class="text-indigo-600 hover:underline"><?= esc($user->phone_number) ?></a>
                </div>
            </div>
        </div>

        <!-- Card: Detail Peserta -->
        <div class="bg-white p-6 rounded-lg shadow-md">
            <h3 class="text-xl font-semibold mb-4 border-b pb-2"><?= lang('Admin/Transactions.sectionParticipants') ?></h3>
            <div class="space-y-6">
                <?php foreach($participants as $index => $p): ?>
                    <div class="border-t pt-4">
                        <div class="flex justify-between items-center mb-2">
                            <h4 class="font-bold text-lg text-indigo-700"><?= lang('Admin/Transactions.participant') ?> #<?= $index + 1 ?>: <?= esc($p->name) ?></h4>
                            <!-- ====== PERUBAHAN UTAMA DI SINI ====== -->
                            <a href="<?= route_to('admin.participants.edit', $p->id) ?>" class="text-sm font-medium text-indigo-600 hover:text-indigo-800 hover:underline"><?= lang('Admin/Transactions.btnEdit') ?></a>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <!-- Kolom Info Teks -->
                            <div class="md:col-span-2 space-y-2 text-sm">
                                <p><strong class="font-medium text-gray-500 w-24 inline-block"><?= lang('Admin/Transactions.fieldEmail') ?>:</strong> <?= esc($p->email) ?></p>
                                <p><strong class="font-medium text-gray-500 w-24 inline-block"><?= lang('Admin/Transactions.fieldPhone') ?>:</strong> 
                                    <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $p->phone_number) ?>" target="_blank" class="text-indigo-600 hover:underline"><?= esc($p->phone_number) ?></a>
                                </p>
                                <p><strong class="font-medium text-gray-500 w-24 inline-block"><?= lang('Admin/Transactions.package') ?>:</strong> <?= esc($p->package_name) ?> (Rp <?= number_format($p->package_price, 0, ',', '.') ?>)</p>
                                <p><strong class="font-medium text-gray-500 w-24 inline-block"><?= lang('Admin/Transactions.church') ?>:</strong> <?= esc($p->joined_church_name ?: $p->church_name) ?></p>
                                <?php if($p->kta_number): ?>
                                    <p><strong class="font-medium text-gray-500 w-24 inline-block"><?= lang('Admin/Transactions.ktaNumber') ?>:</strong> <?= esc($p->kta_number) ?></p>
                                <?php endif; ?>
                                <?php if($p->birth_date && $p->birth_date !== '0000-00-00'): ?>
                                    <p><strong class="font-medium text-gray-500 w-24 inline-block"><?= lang('Admin/Transactions.birthDate') ?>:</strong> <?= date('d M Y', strtotime($p->birth_date)) ?></p>
                                <?php endif; ?>
                                
                                <?php if(!empty($p->custom_fields)): ?>
                                    <div class="mt-2">
                                        <strong class="font-medium text-gray-500"><?= lang('Admin/Transactions.additionalInfo') ?>:</strong>
                                        <dl class="mt-1 space-y-1 pl-4">
                                            <?php foreach($p->custom_fields as $field): ?>
                                                <div>
                                                    <dt class="text-gray-500 font-semibold"><?= esc($field->label) ?>:</dt>
                                                    <dd class="col-span-2 text-gray-800">
                                                        <?php
                                                            // Logika baru yang menangani semua kasus
                                                            $displayValue = $field->value;
                                                            if (is_string($displayValue)) {
                                                                $decoded = json_decode($displayValue, true);
                                                                // Cek jika hasil decode adalah array (menandakan multiple select)
                                                                if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                                                                    $displayValue = implode(', ', $decoded);
                                                                }
                                                            } elseif (is_array($displayValue)) {
                                                                // Ini untuk kasus jika data sudah berupa array (misal dari old() helper)
                                                                $displayValue = implode(', ', $displayValue);
                                                            }
                                                            echo esc($displayValue);
                                                        ?>
                                                    </dd>
                                                </div>
                                            <?php endforeach; ?>
                                        </dl>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Kolom QR Code -->
                            <div class="md:col-span-1 text-center md:text-right">
                                <strong class="font-medium text-gray-500 text-sm"><?= lang('Admin/Transactions.qrCode') ?></strong>
                                <?php if (!empty($p->qr_image_path) && file_exists(WRITEPATH . 'qrcodes/' . $p->qr_image_path)): ?>
                                    <div class="mt-2">
                                        <?php
                                            $path = WRITEPATH . 'qrcodes/' . $p->qr_image_path;
                                            $type = pathinfo($path, PATHINFO_EXTENSION);
                                            $data_img = file_get_contents($path);
                                            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data_img);
                                        ?>
                                        <img src="<?= $base64 ?>" alt="QR Code" class="inline-block w-32 h-32 border">
                                        <p class="font-mono text-center mt-1 text-indigo-600"><?= esc($p->qr_number) ?></p>
                                    </div>
                                <?php else: ?>
                                    <p class="text-xs text-gray-500 mt-2">Not yet generated.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

    </div>

    <!-- Kolom Kanan: Aksi -->
    <div class="lg:col-span-1">
        <div class="bg-white p-6 rounded-lg shadow-md sticky top-24 space-y-8">
            
            <!-- Aksi Utama -->
            <div>
                <h3 class="text-xl font-semibold mb-4"><?= lang('Admin/Transactions.sectionActions') ?></h3>
                <div class="space-y-3">
                    <!-- Form Resend Notification -->
                    <?= form_open(route_to('admin.transactions.resend_notification', $transaction->uuid), ['@submit' => 'isResending = true', 'onsubmit' => "return confirm('".lang('Admin/Transactions.confirmResend')."');"]) ?>
                        <button type="submit" class="w-full inline-flex items-center justify-center text-sm font-medium rounded-md px-4 py-2 bg-blue-600 text-white hover:bg-blue-700 disabled:bg-gray-400 disabled:cursor-wait" :disabled="isResending">
                            <svg x-show="isResending" class="animate-spin -ml-1 mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                            <span x-text="isResending ? 'Sending...' : '<?= lang('Admin/Transactions.btnResendNotif') ?>'"></span>
                        </button>
                    <?= form_close() ?>

                    <!-- Tombol Download PDF -->
                    <?php if ($transaction->payment_status === 'paid'): ?>
                        <a href="<?= route_to('admin.transactions.pdf', $transaction->uuid) ?>"
                           @click="if(isDownloading) { $event.preventDefault(); return; } isDownloading = true; setTimeout(() => { isDownloading = false }, 5000);"
                           :class="{ 'opacity-50 cursor-wait': isDownloading }"
                           class="w-full inline-flex items-center justify-center text-sm font-medium rounded-md px-4 py-2 bg-red-600 text-white hover:bg-red-700 disabled:bg-gray-400 disabled:cursor-wait transition-colors">
                            <svg x-show="isDownloading" class="animate-spin -ml-1 mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                            <span x-text="isDownloading ? 'Preparing...' : '<?= lang('Admin/Transactions.btnDownloadPdf') ?>'"></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Ubah Status -->
            <div class="border-t pt-6">
                <h3 class="text-xl font-semibold mb-4"><?= lang('Admin/Transactions.changeStatus') ?></h3>
                <p class="text-sm text-gray-500 mb-2"><?= lang('Admin/Transactions.currentStatus') ?>: 
                    <span class="font-bold px-2 py-1 text-xs rounded-full <?= $transaction->payment_status === 'paid' ? 'bg-green-100 text-green-800' : ($transaction->payment_status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') ?>">
                        <?= esc(ucfirst($transaction->payment_status)) ?>
                    </span>
                </p>
                
                <?php if (isset($statusOptions[$transaction->payment_status]) && !empty($statusOptions[$transaction->payment_status])): ?>
                    <?= form_open(route_to('admin.transactions.update_status', $transaction->uuid), ['@submit' => 'isUpdatingStatus = true']) ?>
                        <div class="space-y-4">
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Transactions.newStatus') ?></label>
                                <select name="status" id="status" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2 shadow-sm">
                                    <?php foreach ($statusOptions[$transaction->payment_status] as $status): ?>
                                        <option value="<?= $status ?>"><?= ucfirst($status) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div>
                                <label for="notes" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Transactions.notes') ?></label>
                                <textarea name="notes" id="notes" rows="3" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2 shadow-sm"></textarea>
                            </div>
                            <div class="flex items-center">
                                <input type="checkbox" name="notify_user" value="1" id="notify_user" class="h-4 w-4 text-indigo-600 border-gray-300 rounded">
                                <label for="notify_user" class="ml-2 block text-sm text-gray-900"><?= lang('Admin/Transactions.notifyUser') ?></label>
                            </div>
                        </div>
                        <div class="mt-6">
                            <button type="submit" class="w-full inline-flex items-center justify-center bg-indigo-600 text-white font-bold px-4 py-2 rounded-md hover:bg-indigo-700 disabled:bg-gray-400 disabled:cursor-wait" :disabled="isUpdatingStatus">
                                <svg x-show="isUpdatingStatus" class="animate-spin -ml-1 mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                                <span x-text="isUpdatingStatus ? 'Updating...' : '<?= lang('Admin/Transactions.btnUpdateStatus') ?>'"></span>
                            </button>
                        </div>
                    <?= form_close() ?>
                <?php else: ?>
                    <p class="text-gray-600 italic">No further status changes are available for this transaction.</p>
                <?php endif; ?>
            </div>
            
        </div>
    </div>
</div>

<?= $this->endSection() ?>