<?= $this->extend('backend/layouts/main') ?>
<?= $this->section('main') ?>

<div class="bg-white p-8 rounded-lg shadow-md max-w-4xl mx-auto">
    <h3 class="text-2xl font-semibold mb-6 border-b pb-4"><?= lang('Admin/Users.editUser', [esc($user->name)]) ?></h3>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <!-- Form Edit User -->
    <?= form_open(route_to('admin.users.update', $user->id)) ?>
        <?= csrf_field() ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Users.labelName') ?></label>
                <input type="text" name="name" id="name" value="<?= old('name', $user->name) ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" required>
            </div>
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Users.labelEmail') ?></label>
                <input type="email" name="email" id="email" value="<?= old('email', $user->email) ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" required>
                <p class="mt-1 text-xs text-gray-500"><?= lang('Admin/Users.emailNotice') ?></p>
            </div>
            <div>
                <label for="phone_number" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Users.labelPhone') ?></label>
                <input type="tel" name="phone_number" id="phone_number" value="<?= old('phone_number', $user->phone_number) ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" required>
            </div>
            <div>
                <label for="kta_number" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Users.labelKta') ?></label>
                <input type="text" name="kta_number" id="kta_number" value="<?= old('kta_number', $user->kta_number) ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
            </div>
            <div>
                <label for="birth_date" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Users.labelBirthdate') ?></label>
                <input type="date" name="birth_date" id="birth_date" value="<?= old('birth_date', $user->birth_date) ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
            </div>
            <div class="md:col-span-2 flex items-center">
                <input type="checkbox" name="notify_user" value="1" id="notify_user" class="h-4 w-4 text-indigo-600 border-gray-300 rounded">
                <label for="notify_user" class="ml-2 block text-sm text-gray-900"><?= lang('Admin/Users.notifyUser') ?></label>
            </div>
        </div>
        <div class="mt-8 pt-6 border-t flex justify-between items-center">
            <div>
                <button type="submit" class="bg-indigo-600 text-white font-bold px-6 py-2 rounded-md hover:bg-indigo-700"><?= lang('Admin/Users.btnUpdate') ?></button>
                <a href="<?= route_to('admin.users.index') ?>" class="ml-4 text-sm text-gray-600 hover:underline">Cancel</a>
            </div>
            <?php if(has_permission('delete-user')): ?>
                <!-- Form untuk Delete -->
                <?= form_open(route_to('admin.users.delete', $user->id), ['class' => 'inline', 'onsubmit' => "return confirm('".lang('Admin/Users.deleteConfirm')."');"]) ?>
                    <button type="submit" class="text-red-600 hover:text-red-800 hover:underline font-medium disabled:text-gray-400 disabled:cursor-not-allowed" <?= ($user->id == session()->get('user_id')) ? 'disabled' : '' ?>>
                        <?= lang('Admin/Users.btnDelete') ?>
                    </button>
                <?= form_close() ?>
            <?php endif; ?>
        </div>
    <?= form_close() ?>
</div>
<?= $this->endSection() ?>