<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>

<!-- Form Filter -->
<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h4 class="text-xl font-semibold mb-4"><?= lang('Admin/Users.filter') ?></h4>
    <form action="<?= current_url() ?>" method="get" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
        <div>
            <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Users.filterName') ?></label>
            <input type="text" name="name" id="name" value="<?= esc($filters['name'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>
        <div>
            <label for="email" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Users.filterEmail') ?></label>
            <input type="email" name="email" id="email" value="<?= esc($filters['email'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>
        <div>
            <label for="phone_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Users.filterPhone') ?></label>
            <input type="tel" name="phone_number" id="phone_number" value="<?= esc($filters['phone_number'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>
        <div>
            <label for="kta_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Users.filterKta') ?></label>
            <input type="text" name="kta_number" id="kta_number" value="<?= esc($filters['kta_number'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>
        <div>
            <label for="birth_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Users.filterBirthdate') ?></label>
            <input type="date" name="birth_date" id="birth_date" value="<?= esc($filters['birth_date'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>
        <div class="col-span-full flex items-end gap-4">
            <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 shadow-sm"><?= lang('Admin/Users.btnFilter') ?></button>
            <a href="<?= route_to('admin.users.index') ?>" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-300 shadow-sm"><?= lang('Admin/Users.btnReset') ?></a>
        </div>
    </form>
</div>

<!-- Tabel Data -->
<div class="overflow-x-auto bg-white rounded-lg shadow-md">
    <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Users.colName') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Users.colContact') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Users.colKta') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Users.colVerified') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Users.colActions') ?></th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            <?php if (!empty($users)): foreach ($users as $user): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?= esc($user->name) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?= esc($user->email) ?><br>
                        <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $user->phone_number) ?>" target="_blank" class="text-indigo-600 hover:underline"><?= esc($user->phone_number) ?></a>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($user->kta_number) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <?php if($user->email_verified_at): ?>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Email</span>
                        <?php endif; ?>
                        <?php if($user->phone_verified_at): ?>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">Phone</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <?php if(has_permission('edit-user')): ?>
                            <a href="<?= route_to('admin.users.edit', $user->id) ?>" class="text-indigo-600 hover:underline">Edit</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; else: ?>
                <tr><td colspan="5" class="px-6 py-4 text-center text-gray-500"><?= lang('Admin/Users.noResults') ?></td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<div class="mt-6"><?= $pager->links('default', 'tailwind') ?></div>

<?= $this->endSection() ?>