<!DOCTYPE html>
<html>
<body style="font-family: sans-serif; color: #333;">
    <div style="max-width: 600px; margin: auto; padding: 20px; border: 1px solid #ddd; border-radius: 5px;">
        <h2 style="color: #4f46e5;">Your Order has been Received!</h2>
        <p>Hello <?= esc($user->name) ?>,</p>
        <p>Thank you for your registration. Your order is currently pending payment. Here are the details:</p>
        
        <hr>
        <p><strong>Invoice Number:</strong> <?= esc($transaction->invoice_number) ?></p>
        <p><strong>Transaction Date:</strong> <?= date('d M Y, H:i', strtotime($transaction->created_at)) ?></p>
        <p><strong>Total Amount:</strong> Rp <?= number_format($transaction->total_amount, 0, ',', '.') ?></p>
        <p><strong>Payment Method:</strong> <?= esc(ucwords(str_replace('_', ' ', $transaction->payment_type))) ?></p>
        <hr>

        <h3 style="color: #333;">Participant Details:</h3>
        <ul style="list-style-type: none; padding: 0;">
            <?php foreach($participants as $p): ?>
                <li style="margin-bottom: 10px; border-bottom: 1px solid #eee; padding-bottom: 10px;">
                    <strong><?= esc($p->name) ?></strong><br>
                    <small style="color: #777;"><?= esc($p->email) ?> | <?= esc($p->phone_number) ?></small>
                </li>
            <?php endforeach; ?>
        </ul>
        
        <p>Please complete your payment to finalize your registration. You can view your transaction details on your dashboard.</p>
    </div>
</body>
</html>