<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($subject)  ?></title>
</head>
<body style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol'; color: #3d4852; font-size: 16px; line-height: 1.5em; margin: 0; padding: 0; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;">
    <table width="100%" cellpadding="0" cellspacing="0" role="presentation" style="background-color: #edf2f7; padding: 30px;">
        <tr>
            <td align="center">
                <table width="100%" cellpadding="0" cellspacing="0" role="presentation" style="max-width: 600px; margin: 0 auto;">
                    <!-- Header -->
                    <tr>
                        <td style="padding: 25px; text-align: center;">
                            <a href="<?= site_url() ?>" style="font-size: 24px; font-weight: bold; color: #4f46e5; text-decoration: none;">
                                <?= getenv('app.name')  ?>
                            </a>
                        </td>
                    </tr>
                    
                    <!-- Body -->
                    <tr>
                        <td width="100%" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-bottom: 1px solid #e8e5ef; border-top: 1px solid #e8e5ef; padding: 40px;">
                            <h1 style="color: #3d4852; font-size: 18px; font-weight: bold; margin-top: 0;"><?= esc($greeting) ?></h1>
                            <p style="font-size: 16px; line-height: 1.5em; margin-top: 0;"><?= $message ?></p>
                            
                            <table align="center" width="100%" cellpadding="0" cellspacing="0" role="presentation" style="margin: 30px auto; text-align: center;">
                                <tr>
                                    <td align="center">
                                        <a href="<?= $verificationLink  ?>" target="_blank" style="display: inline-block; padding: 12px 24px; font-size: 16px; font-weight: bold; background-color: #4f46e5; color: #ffffff; text-decoration: none; border-radius: 5px; -webkit-text-size-adjust: none; box-sizing: border-box;">
                                            <?= esc($buttonText) ?>
                                        </a>
                                    </td>
                                </tr>
                            </table>
                            
                            <p style="font-size: 16px; line-height: 1.5em; margin-top: 0;"><?= esc($backupText) ?></p>
                            <p style="font-size: 12px; line-height: 1.5em; margin-top: 0;">
                                <a href="<?= $verificationLink ?>" target="_blank" style="color: #4f46e5; word-break: break-all;"><?= $verificationLink ?></a>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <td style="padding: 25px; text-align: center;">
                            <p style="font-size: 12px; color: #718096;">© <?= date('Y') ?> <?= getenv('app.name') ?>. All rights reserved.</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>