<!-- app/Views/frontend/auth/verify_choice.php -->
<?= $this->extend('frontend/layouts/main') ?>
<?= $this->section('pageTitle') ?><?= lang('Verification.choicePageTitle') ?><?= $this->endSection() ?>

<?= $this->section('mainContent') ?>
<div class="flex items-center justify-center min-h-[calc(100vh-150px)]"
     x-data="{ 
         cooldown: <?= $cooldown ?? 0 ?>,
         timer: null,
         startTimer() {
             if (this.cooldown > 0) {
                 this.timer = setInterval(() => {
                     this.cooldown--;
                     if (this.cooldown <= 0) {
                         clearInterval(this.timer);
                     }
                 }, 1000);
             }
         }
     }"
     x-init="startTimer()">
    <div class="w-full max-w-md p-8 space-y-6 bg-white rounded-lg shadow-md text-center">
        <h1 class="text-3xl font-bold text-gray-800"><?= lang('Verification.choiceMainHeading') ?></h1>
        <p class="text-gray-600"><?= lang('Verification.choiceSubHeading') ?></p>
        
        <?= $this->include('frontend/components/_notifications') ?>

        <div class="flex flex-col sm:flex-row gap-4 pt-4 items-center sm:justify-center">
            
            <!-- Form untuk verifikasi Email (INI SATU-SATUNYA YANG TERSISA) -->
            <?= form_open(route_to('verify.send')) ?>
                <input type="hidden" name="medium" value="email">
                <button type="submit" 
                        class="w-full flex justify-center text-white bg-indigo-600 hover:bg-indigo-700 focus:ring-4 focus:ring-indigo-300 font-medium rounded-lg text-sm px-5 py-3 disabled:bg-gray-400 disabled:cursor-not-allowed" 
                        :disabled="cooldown > 0">
                    <span x-show="cooldown <= 0"><?= lang('Verification.choiceBtnEmail') ?></span>
                    <span x-show="cooldown > 0" x-text="`Resend in ${cooldown}s`"></span>
                </button>
            <?= form_close() ?>

            <!-- Form untuk verifikasi WhatsApp -->
            <?php /*
            <?= form_open(route_to('verify.send')) ?>
                <input type="hidden" name="medium" value="whatsapp">
                 <button type="submit" 
                         class="w-full flex justify-center text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:ring-green-300 font-medium rounded-lg text-sm px-5 py-3 disabled:bg-gray-400 disabled:cursor-not-allowed" 
                         :disabled="cooldown > 0">
                    <span x-show="cooldown <= 0"><?= lang('Verification.choiceBtnWhatsapp') ?></span>
                    <span x-show="cooldown > 0" x-text="`Resend in ${cooldown}s`"></span>
                </button>
            <?= form_close() ?>
            */ ?>
        </div>
        
        <p class="text-sm text-gray-500 mt-4">For now, verification is only available via email.</p>
    </div>
</div>
<?= $this->endSection() ?>