<?= $this->extend('frontend/layouts/main') ?>
<?= $this->section('pageTitle') ?><?= lang('Profile.pageTitle') ?><?= $this->endSection() ?>

<?= $this->section('mainContent') ?>
<!-- Tambahkan state untuk setiap form -->
<div class="container mx-auto px-4 py-8" 
     x-data="{ 
        tab: 'details',
        isDetailsSubmitting: false,
        isEmailSubmitting: false,
        isPasswordSubmitting: false
     }">

    <h1 class="text-3xl font-bold text-gray-800 mb-8"><?= lang('Profile.mainHeading') ?></h1>

    <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
        <!-- Menu Kiri (Tab) -->
        <div class="md:col-span-1">
            <div class="bg-white p-4 rounded-lg shadow-md">
                <ul class="space-y-1">
                    <li><a href="#" @click.prevent="tab = 'details'" class="block px-4 py-2 rounded-md font-medium" :class="tab === 'details' ? 'bg-indigo-600 text-white' : 'hover:bg-gray-100'"><?= lang('Profile.tabDetails') ?></a></li>
                    <li><a href="#" @click.prevent="tab = 'email'" class="block px-4 py-2 rounded-md font-medium" :class="tab === 'email' ? 'bg-indigo-600 text-white' : 'hover:bg-gray-100'"><?= lang('Profile.tabEmail') ?></a></li>
                    <li><a href="#" @click.prevent="tab = 'password'" class="block px-4 py-2 rounded-md font-medium" :class="tab === 'password' ? 'bg-indigo-600 text-white' : 'hover:bg-gray-100'"><?= lang('Profile.tabPassword') ?></a></li>
                </ul>
            </div>
        </div>

        <!-- Konten Kanan -->
        <div class="md:col-span-3">
            <?= $this->include('frontend/components/_notifications') ?>
            
            <!-- Tab 1: Profile Details -->
            <div x-show="tab === 'details'" class="bg-white p-8 rounded-lg shadow-md" x-cloak>
                <form method="POST" action="<?= route_to('profile.update.details') ?>" @submit="isDetailsSubmitting = true">
                    <?= csrf_field() ?>
                    <div class="space-y-4">
                        <!-- ... input fields ... -->
                        <div>
                            <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelName') ?></label>
                            <input type="text" name="name" id="name" value="<?= old('name', $user->name) ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                        </div>
                        <div>
                            <label for="phone_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelPhone') ?></label>
                            <input type="tel" name="phone_number" id="phone_number" value="<?= old('phone_number', $user->phone_number) ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                        </div>
                        <div>
                            <label for="kta_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelKta') ?></label>
                            <input type="text" name="kta_number" id="kta_number" value="<?= old('kta_number', $user->kta_number) ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                        </div>
                        <div>
                            <label for="birth_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelBirthdate') ?></label>
                            <input type="date" name="birth_date" id="birth_date" value="<?= old('birth_date', $user->birth_date) ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                        </div>
                    </div>
                    <div class="mt-6">
                        <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center bg-indigo-600 hover:bg-indigo-700 text-white font-bold px-4 py-2 rounded-md disabled:bg-gray-400 disabled:cursor-wait" :disabled="isDetailsSubmitting">
                            <svg x-show="isDetailsSubmitting" class="animate-spin -ml-1 mr-3 h-5 w-5" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                            <span x-show="!isDetailsSubmitting"><?= lang('Profile.btnSaveChanges') ?></span>
                            <span x-show="isDetailsSubmitting">Saving...</span>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Tab 2: Change Email -->
            <div x-show="tab === 'email'" class="bg-white p-8 rounded-lg shadow-md" x-cloak>
                <form method="POST" action="<?= route_to('profile.email.request') ?>" @submit="isEmailSubmitting = true">
                    <?= csrf_field() ?>
                    <p class="mb-2"><?= lang('Profile.currentEmail', [esc($user->email)]) ?></p>
                    <p class="text-sm text-gray-600 mb-4"><?= lang('Profile.emailChangeInfo') ?></p>
                    <div>
                        <label for="new_email" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelNewEmail') ?></label>
                        <input type="email" name="new_email" id="new_email" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                    </div>
                    <div class="mt-6">
                        <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center bg-indigo-600 hover:bg-indigo-700 text-white font-bold px-4 py-2 rounded-md disabled:bg-gray-400 disabled:cursor-wait" :disabled="isEmailSubmitting">
                             <svg x-show="isEmailSubmitting" class="animate-spin -ml-1 mr-3 h-5 w-5" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                            <span x-show="!isEmailSubmitting"><?= lang('Profile.btnRequestChange') ?></span>
                            <span x-show="isEmailSubmitting">Sending...</span>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Tab 3: Change Password -->
            <div x-show="tab === 'password'" class="bg-white p-8 rounded-lg shadow-md" x-cloak>
                <form method="POST" action="<?= route_to('profile.update.password') ?>" @submit="isPasswordSubmitting = true">
                    <?= csrf_field() ?>
                    <div class="space-y-4">
                        <div>
                            <label for="current_password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelCurrentPass') ?></label>
                            <input type="password" name="current_password" id="current_password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                        </div>
                        <div>
                            <label for="new_password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelNewPass') ?></label>
                            <input type="password" name="new_password" id="new_password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                        </div>
                        <div>
                            <label for="confirm_new_password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Profile.labelConfirmPass') ?></label>
                            <input type="password" name="confirm_new_password" id="confirm_new_password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                        </div>
                    </div>
                    <div class="mt-6">
                        <button type="submit" class="w-full sm:w-auto inline-flex items-center justify-center bg-indigo-600 hover:bg-indigo-700 text-white font-bold px-4 py-2 rounded-md disabled:bg-gray-400 disabled:cursor-wait" :disabled="isPasswordSubmitting">
                            <svg x-show="isPasswordSubmitting" class="animate-spin -ml-1 mr-3 h-5 w-5" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                            <span x-show="!isPasswordSubmitting"><?= lang('Profile.btnChangePass') ?></span>
                            <span x-show="isPasswordSubmitting">Updating...</span>
                        </button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>
<?= $this->endSection() ?>