<!-- app/Views/frontend/transaction/show.php -->
<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('pageTitle') ?>Transaction Details: <?= esc($transaction->invoice_number) ?><?= $this->endSection() ?>

<?= $this->section('mainContent') ?>
<div class="container mx-auto px-4 py-8 max-w-5xl" 
    x-data="{ 
        showModal: false, 
        selectedParticipant: null,
        isDownloading: false,
        openParticipantModal(participant) {
            this.selectedParticipant = participant;
            this.showModal = true;
        },
        formatFieldValue(value) {
            if (!value) return '';
            if (value.startsWith('[') && value.endsWith(']')) {
                try {
                    const arr = JSON.parse(value);
                    return arr.join(', ');
                } catch (e) {
                    return value;
                }
            }
            return value;
        }
    }">

    <div class="bg-white p-6 sm:p-8 rounded-lg shadow-md">
        <!-- Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start pb-6 mb-6 border-b border-gray-200">
             <div>
                <h1 class="text-3xl font-bold text-gray-800">Transaction Details</h1>
                <p class="text-gray-600">Invoice # <span class="font-semibold text-indigo-600"><?= esc($transaction->invoice_number) ?></span></p>
            </div>
            <?php
                $statusClass = 'bg-yellow-100 text-yellow-800'; if ($transaction->payment_status === 'paid') { $statusClass = 'bg-green-100 text-green-800'; } elseif (in_array($transaction->payment_status, ['canceled', 'rejected'])) { $statusClass = 'bg-red-100 text-red-800'; }
            ?>
            <span class="mt-2 sm:mt-0 px-4 py-2 text-sm font-semibold rounded-full <?= $statusClass ?>">Status: <?= esc(ucfirst($transaction->payment_status)) ?></span>
        </div>
        
        <!-- Tombol Aksi -->
        <div class="flex flex-wrap gap-4 mb-8">
            <a href="<?= route_to('dashboard.show') ?>" class="bg-gray-200 text-gray-800 px-4 py-2 text-sm font-semibold rounded-md hover:bg-gray-300">← Back to Dashboard</a>
            
            <?php if ($transaction->payment_status === 'paid'): ?>
                <!-- Tombol Download PDF dengan Timeout -->
                <a href="<?= route_to('transaction.pdf', $transaction->uuid) ?>"
                   @click="
                       if(isDownloading) { 
                           $event.preventDefault(); 
                           return; 
                       } 
                       isDownloading = true;
                       setTimeout(() => { isDownloading = false }, 5000); 
                   "
                   :class="{ 'opacity-50 cursor-wait': isDownloading }"
                   class="inline-flex items-center bg-red-600 text-white px-4 py-2 text-sm font-semibold rounded-md hover:bg-red-700 transition-all duration-300">
                    <svg x-show="isDownloading" class="animate-spin -ml-1 mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                    <span x-text="isDownloading ? 'Preparing...' : 'Download PDF'"></span>
                </a>
            <?php endif; ?>
            
            <a href="<?= route_to('transaction.new') ?>" class="bg-indigo-600 text-white px-4 py-2 text-sm font-semibold rounded-md hover:bg-indigo-700">+ Create New Transaction</a>
        </div>
        
        <!-- Notifikasi -->
        <?php if (in_array($transaction->payment_type, ['manual_transfer', 'cash']) && $transaction->payment_status === 'pending'): ?>
            <div class="bg-blue-100 border-l-4 border-blue-500 text-blue-700 p-4 mb-6 rounded-r-lg" role="alert">
                <p class="font-bold">Action Required</p>
                <p>Your registration is pending. Please complete the payment via <?= esc(str_replace('_', ' ', $transaction->payment_type)) ?> and confirm with the event committee.</p>
            </div>
        <?php endif; ?>

        <!-- Daftar Peserta -->
        <div class="mt-10">
            <h2 class="text-xl font-semibold text-gray-700 mb-4">Participant(s)</h2>
            <div class="overflow-x-auto border border-gray-200 rounded-lg">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Package & Price</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">QR Code</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php foreach ($participants as $p): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?= esc($p->name) ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <?= esc($p->package_name) ?><br>
                                <span class="text-xs text-gray-400">Rp <?= number_format($p->package_price, 0, ',', '.') ?></span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-mono text-gray-700 tracking-wider">
                                <?= esc($p->qr_number) ?: '<span class="text-red-500">Pending Payment</span>' ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                                <button @click="openParticipantModal(<?= htmlspecialchars(json_encode($p)) ?>)" class="text-indigo-600 hover:text-indigo-900 font-medium">View Details</button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal untuk Detail Peserta -->
    <div x-show="showModal" 
         class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 p-4 transition-opacity" 
         x-transition:enter="ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         x-cloak>
        <div @click.away="showModal = false" 
             class="bg-white rounded-lg shadow-xl w-full max-w-lg max-h-[90vh] flex flex-col"
             x-show="showModal"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave="ease-in duration-200"
             x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
             x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95">
            
            <div class="p-6 border-b">
                <div class="flex justify-between items-center">
                    <h3 class="text-2xl font-bold text-gray-800" x-text="selectedParticipant?.name"></h3>
                    <button @click="showModal = false" class="text-gray-400 hover:text-gray-600 text-3xl">×</button>
                </div>
            </div>
            
            <div class="p-6 space-y-3 text-sm overflow-y-auto" x-show="selectedParticipant">
                <p><strong class="font-medium text-gray-600 w-32 inline-block">Church:</strong> <span class="text-gray-800" x-text="selectedParticipant?.joined_church_name || selectedParticipant?.church_name || 'N/A'"></span>
                </p>
                <p><strong class="font-medium text-gray-600 w-32 inline-block">Phone:</strong> <span class="text-gray-800" x-text="selectedParticipant?.phone_number"></span></p>
                <p><strong class="font-medium text-gray-600 w-32 inline-block">Email:</strong> <span class="text-gray-800" x-text="selectedParticipant?.email"></span></p>
                <template x-if="selectedParticipant?.kta_number"><p><strong class="font-medium text-gray-600 w-32 inline-block">KTA Number:</strong> <span class="text-gray-800" x-text="selectedParticipant?.kta_number"></span></p></template>
                <template x-if="selectedParticipant?.birth_date && selectedParticipant?.birth_date !== '0000-00-00'"><p><strong class="font-medium text-gray-600 w-32 inline-block">Birth Date:</strong> <span class="text-gray-800" x-text="selectedParticipant?.birth_date"></span></p></template>
                
                <template x-if="selectedParticipant?.custom_fields && selectedParticipant.custom_fields.length > 0">
                    <div>
                        <h4 class="font-semibold text-gray-700 mt-6 mb-2 border-t pt-4">Additional Info</h4>
                        <dl class="space-y-2">
                            <template x-for="field in selectedParticipant.custom_fields" :key="field.label">
                                <div class="grid grid-cols-3 gap-4">
                                    <dt class="font-medium text-gray-600 col-span-1" x-text="field.label + ':'"></dt>
                                    <dd class="text-gray-800 col-span-2" x-text="formatFieldValue(field.value)"></dd>
                                </div>
                            </template>
                        </dl>
                    </div>
                </template>
            </div>
            
            <div class="bg-gray-50 px-6 py-4 border-t text-right">
                <button @click="showModal = false" class="bg-gray-200 text-gray-800 px-4 py-2 text-sm font-semibold rounded-md hover:bg-gray-300">Close</button>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>