<?php
namespace App\Controllers\Backend;

use App\Controllers\BaseController;

class DashboardController extends BaseController
{
    public function index()
    {
        $data['pageTitle'] = lang('Admin/Layout.dashboard');
        return view('backend/dashboard/index', $data);
    }

    public function clearCache()
    {
        if (cache()->clean()) {
            return redirect()->back()->with('success', 'Application cache has been cleared successfully.');
        }
        return redirect()->back()->with('error', 'Could not clear the application cache.');
    }
}