<?php
namespace App\Controllers\Backend;

use App\Controllers\BaseController;
use App\Models\EventPaymentMethodModel;
use App\Models\EventModel;

class EventPaymentMethodController extends BaseController
{

    public function new(int $eventId)
    {
        $event = (new EventModel())->find($eventId);
        if (!$event) {
            return redirect()->route('admin.events.index')->with('error', 'Event not found.');
        }

        $data = [
            'event'     => $event,
            'pageTitle' => 'New Payment Method for: ' . $event->name,
        ];
        // Muat view dari struktur direktori yang benar
        return view('backend/events/payment_method/new', $data);
    }


    public function create(int $eventId)
    {
        if (!$this->validate($this->getValidationRules($eventId))) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }


        $paymentMethodModel = new EventPaymentMethodModel();
        $id = $paymentMethodModel->insert([
            'event_id'  => $eventId,
            'name'      => $this->request->getPost('name'),
            'method'    => $this->request->getPost('method'),
            'fee'       => $this->request->getPost('fee') ?? 0,
            'is_active' => (int)$this->request->getPost('is_active') ?? 0,
        ]);



        return redirect()->to(route_to('admin.events.show', $eventId))->with('success', lang('Admin/Events.paymentCreateSuccess'));
    }
    

    public function edit(int $eventId, int $methodId)
    {
        $paymentModel = new EventPaymentMethodModel();
        $method = $paymentModel->find($methodId);
        if (!$method || $method->event_id != $eventId) {
            return redirect()->back()->with('error', lang('Admin/PaymentMethods.errorNotFound'));
        }

        $data = [
            'event'     => (new EventModel())->find($eventId),
            'method'    => $method,
            'pageTitle' => lang('Admin/PaymentMethods.editMethod'),
        ];
        
        return view('backend/events/payment_method/edit', $data);
    }
    
    public function update(int $eventId, int $methodId)
    {
        if (!$this->validate($this->getValidationRules($eventId, $methodId))) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        (new EventPaymentMethodModel())->save([
            'id'        => $methodId,
            'event_id'  => $eventId,
            'name'      => $this->request->getPost('name'),
            'method'    => $this->request->getPost('method'),
            'fee'       => $this->request->getPost('fee') ?? 0,
            'is_active' => (int)$this->request->getPost('is_active') ?? 0,
        ]);
        
        return redirect()->to(route_to('admin.events.show', $eventId))->with('success', lang('Admin/Events.paymentUpdateSuccess'));
    }


    public function delete(int $eventId, int $methodId)
    {
        $paymentModel = new EventPaymentMethodModel();
        $method = $paymentModel->find($methodId);
        if ($method && $method->event_id == $eventId) {
            $paymentModel->delete($methodId);
            return redirect()->to(route_to('admin.events.show', $eventId))->with('success', lang('Admin/Events.paymentDeleteSuccess'));
        }
        
        return redirect()->to(route_to('admin.events.show', $eventId))->with('error', 'Failed to delete payment method.');
    }


    private function getValidationRules(int $eventId, int $ignoreId = null): array
    {
        //$rule = "required|in_list[cash,va,transfer]|is_unique[event_payment_methods.method,event_id,{$eventId},id,{$ignoreId}]";
        $rule = "required|in_list[cash,va,transfer]";
        return [
            'name'   => 'required|string|max_length[100]',
            'method' => $rule,
            'fee'    => 'permit_empty|numeric',
        ];
    }
}