<?php
// File: app/Controllers/Frontend/DashboardController.php

namespace App\Controllers\Frontend;

use App\Controllers\BaseController;
use App\Models\TransactionModel; // Kita butuh model ini

class DashboardController extends BaseController
{
    /**
     * Menampilkan halaman dashboard utama untuk user.
     */
    public function showDashboard()
    {
        // Pastikan user sudah login (ini akan di-handle oleh filter)
        $userId = session()->get('user_id');

        // Inisialisasi model
        $transactionModel = new TransactionModel();

        // Ambil semua transaksi milik user ini, urutkan dari yang terbaru
        $transactions = $transactionModel->where('user_id', $userId)
                                         ->orderBy('created_at', 'DESC')
                                         ->findAll();

        // Siapkan data untuk dikirim ke view
        $data = [
            'transactions' => $transactions,
            'userName' => session()->get('user_name') // Ambil nama user dari sesi
        ];

        // Muat view dan kirim data
        return view('frontend/dashboard/index', $data);
    }
}