<?php

namespace App\Models;

use CodeIgniter\Model;

class EventPaymentMethodModel extends Model
{
    protected $table            = 'event_payment_methods';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;

    protected $allowedFields    = ['event_id', 'method', 'name', 'fee', 'is_active'];

    protected $useTimestamps    = false;
    
    protected $validationRules = [
        'event_id'  => 'required|is_natural_no_zero',
        'method'    => 'required|in_list[cash,va,transfer]',
        'fee'       => 'is_natural',
        'is_active' => 'in_list[0,1]',
    ];


}