<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
    
    <!-- Load CSS untuk Select2 di sini -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        /* Perbaikan styling agar Select2 cocok dengan Tailwind */
        .select2-container .select2-selection--single { height: 42px; }
        .select2-container--default .select2-selection--single { border: 1px solid #D1D5DB; border-radius: 0.5rem; background-color: #F9FAFB; }
        .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 40px; padding-left: 0.75rem; color: #111827; }
        .select2-container--default .select2-selection--single .select2-selection__arrow { height: 40px; }
        .select2-container--default.select2-container--open .select2-selection--single { border-color: #4f46e5; }
    </style>

    <div class="bg-white p-8 rounded-lg shadow-md max-w-4xl mx-auto">
        <h3 class="text-2xl font-semibold mb-6 border-b pb-4"><?= lang('Admin/BulkTransactions.formHeader') ?></h3>
        
        <?= $this->include('backend/layouts/_notifications') ?>

        <?= form_open_multipart(route_to('admin.bulk.create')) ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                
                <div class="md:col-span-2">
                    <label for="event_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelEvent') ?></label>
                    <select name="event_id" id="event_id" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                        <option value="">-- Select Event --</option>
                        <?php foreach($events as $event): ?>
                            <option value="<?= $event->id ?>" <?= set_select('event_id', $event->id) ?>><?= esc($event->name) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div>
                    <label for="event_package_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelPackage') ?></label>
                    <select name="event_package_id" id="event_package_id" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required disabled>
                        <option value="">-- Select Event First --</option>
                    </select>
                </div>
                
                <div>
                    <label for="payment_type" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelPayment') ?></label>
                    <select name="payment_type" id="payment_type" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                        <option value="transfer" <?= set_select('payment_type', 'transfer') ?>>Manual Transfer</option>
                        <option value="cash" <?= set_select('payment_type', 'cash') ?>>Cash</option>
                    </select>
                </div>
                
                <div class="md:col-span-2">
                    <label for="user_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelUser') ?></label>
                    <select name="user_id" id="user_id" style="width: 100%;" required></select>
                </div>

                <div class="md:col-span-2">
                    <label for="church_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelChurch') ?></label>
                    <select name="church_id" id="church_id" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                        <option value="">-- Select Church --</option>
                        <?php foreach($churches as $church): ?>
                            <option value="<?= $church->id ?>" <?= set_select('church_id', $church->id) ?>><?= esc($church->name) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div>
                    <label for="transaction_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelTrxDate') ?></label>
                    <input type="date" name="transaction_date" id="transaction_date" value="<?= old('transaction_date', date('Y-m-d')) ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                </div>
                
                <div>
                    <label for="invoice_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelInvoice') ?></label>
                    <input type="text" name="invoice_number" id="invoice_number" value="<?= old('invoice_number') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                    <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/BulkTransactions.invoiceHelp') ?></p>
                </div>
                
                <div class="md:col-span-2">
                    <label for="description" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelDesc') ?></label>
                    <textarea name="description" id="description" rows="3" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5"><?= old('description') ?></textarea>
                </div>

                <div class="md:col-span-2">
                    <label for="excel_file" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/BulkTransactions.labelExcel') ?></label>
                    <input type="file" name="excel_file" id="excel_file" accept=".xlsx, .xls" required class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                    <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/BulkTransactions.excelHelp') ?></p>
                </div>
            </div>
            <div class="mt-8 pt-6 border-t flex justify-end">
                <button type="submit" class="bg-indigo-600 text-white font-bold px-6 py-2 rounded-md hover:bg-indigo-700">
                    <?= lang('Admin/BulkTransactions.btnUpload') ?>
                </button>
            </div>
        </div>
    <?= form_close() ?>

    <!-- Load JS di bagian bawah section 'main' -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#user_id').select2({
                placeholder: 'Search user by email or name',
                width: '100%',
                ajax: {
                    url: "<?= route_to('admin.ajax.users') ?>",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) { return { term: params.term || '' }; },
                    processResults: function (data) { return { results: data.results }; },
                    cache: true
                }
            });
            
            /*
            $('#church_id').select2({
                placeholder: 'Search church by name or city',
                width: '100%',
                ajax: {
                    url: "<?= route_to('admin.ajax.churches') ?>",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) { return { term: params.term || '' }; },
                    processResults: function (data) { return { results: data.results }; },
                    cache: true
                }
            });
            */

            $('#event_id').on('change', function() {
                const eventId = $(this).val();
                const packageSelect = $('#event_package_id');
                const baseUrl = "<?= site_url('backend/ajax/packages/') ?>";
                
                packageSelect.empty().append('<option value="">Loading...</option>').prop('disabled', true);

                if (eventId) {
                    $.getJSON(baseUrl + eventId, function(data) {
                        packageSelect.empty().append('<option value="">-- Select Package --</option>');
                        if(data && data.length > 0){
                            $.each(data, function(key, entry) {
                                packageSelect.append($('<option></option>').attr('value', entry.id).text(entry.name));
                            });
                            packageSelect.prop('disabled', false);
                        } else {
                            packageSelect.empty().append('<option value="">-- No packages found --</option>');
                        }
                    });
                } else {
                    packageSelect.empty().append('<option value="">-- Select Event First --</option>').prop('disabled', true);
                }
            });

            // Memicu 'change' event jika ada nilai lama (setelah validasi gagal)
            if ($('#event_id').val()) {
                $('#event_id').trigger('change');
            }
        });
    </script>
<?= $this->endSection() ?>