<?= $this->extend('backend/layouts/main') ?>
<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-2xl font-semibold text-gray-800"><?= esc($pageTitle) ?></h2>
            <a href="<?= route_to('admin.bulk.index') ?>" class="text-sm text-indigo-600 hover:underline">← Back to Bulk Upload List</a>
        </div>
    </div>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <!-- Ringkasan Upload -->
    <div class="bg-white p-6 rounded-lg shadow-md mb-8">
        <h3 class="text-xl font-semibold mb-4 border-b pb-2"><?= lang('Admin/BulkTransactions.summary') ?></h3>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-x-6 gap-y-4 text-sm">
            <div><strong class="font-medium text-gray-500">Event:</strong><br><?= esc($event->name ?? 'N/A') ?></div>
            <div><strong class="font-medium text-gray-500">Package:</strong><br><?= esc($package->name ?? 'N/A') ?></div>
            <div><strong class="font-medium text-gray-500">Payment:</strong><br><?= esc(ucfirst($bulkTransaction->payment_type)) ?></div>
            <div><strong class="font-medium text-gray-500">Registered By:</strong><br><?= esc($user->name ?? 'N/A') ?></div>
            <div><strong class="font-medium text-gray-500">Default Church:</strong><br><?= esc($church->name ?? 'N/A') ?></div>
            <div><strong class="font-medium text-gray-500">Transaction Date:</strong><br><?= date('d M Y', strtotime($bulkTransaction->transaction_date)) ?></div>
        </div>
    </div>

    <!-- Statistik Validasi -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 my-6">
        <div class="bg-blue-100 p-4 rounded-lg shadow text-center"><div class="text-3xl font-bold text-blue-900"><?= $totalRows ?></div><div class="text-sm font-semibold text-blue-800"><?= lang('Admin/BulkTransactions.totalRows') ?></div></div>
        <div class="bg-green-100 p-4 rounded-lg shadow text-center"><div class="text-3xl font-bold text-green-900"><?= $validRows ?></div><div class="text-sm font-semibold text-green-800"><?= lang('Admin/BulkTransactions.validRows') ?></div></div>
        <div class="bg-red-100 p-4 rounded-lg shadow text-center"><div class="text-3xl font-bold text-red-900"><?= $invalidRows ?></div><div class="text-sm font-semibold text-red-800"><?= lang('Admin/BulkTransactions.invalidRows') ?></div></div>
    </div>

    <!-- Daftar Error (jika ada) -->
    <?php if($invalidRows > 0): ?>
        <div class="bg-white p-6 rounded-lg shadow-md mb-8">
            <h4 class="text-xl font-semibold mb-4 text-red-700"><?= lang('Admin/BulkTransactions.errorList') ?></h4>
            <ul class="list-disc list-inside text-sm text-gray-700 space-y-2 max-h-60 overflow-y-auto bg-gray-50 p-4 rounded">
                <?php foreach($errors as $error): ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- Tombol Aksi -->
    <div class="bg-white p-6 rounded-lg shadow-md flex items-center justify-between">
        <?php if($bulkTransaction->process_status === 'Validated'): ?>
            <?php if($validRows >= 0): ?>
                <p>Ready to process <strong><?= $validRows ?></strong> valid participants.</p>
                <div class="flex gap-4">
                    <?= form_open(route_to('admin.bulk.delete', $bulkTransaction->id), ['class' => 'inline', 'onsubmit' => "return confirm('Are you sure you want to cancel this entire upload?');"]) ?>
                        <button type="submit" class="bg-red-600 text-white font-bold px-4 py-2 rounded-md hover:bg-red-700"><?= lang('Admin/BulkTransactions.btnCancel') ?></button>
                    <?= form_close() ?>
                    <?= form_open(route_to('admin.bulk.process', $bulkTransaction->id), ['class' => 'inline', 'onsubmit' => "return confirm('".lang('Admin/BulkTransactions.processConfirm', [$validRows])."');"]) ?>
                        <button type="submit" class="bg-green-600 text-white font-bold px-4 py-2 rounded-md hover:bg-green-700"><?= lang('Admin/BulkTransactions.btnProcess', [$validRows]) ?></button>
                    <?= form_close() ?>
                </div>
            <?php else: ?>
                <p class="text-red-700 font-semibold"><?= lang('Admin/BulkTransactions.noValidParticipants') ?></p>
            <?php endif; ?>
        <?php elseif($bulkTransaction->process_status === 'Success'): ?>
            <p class="text-green-700 font-semibold">This bulk upload has been successfully processed.</p>
        <?php else: ?>
            <p class="text-gray-600 italic">This upload is in '<?= esc($bulkTransaction->process_status) ?>' state and cannot be processed.</p>
        <?php endif; ?>
    </div>

    <!-- Daftar Peserta Temporer -->
    <div class="mt-8">
        <h4 class="text-xl font-semibold mb-4"><?= lang('Admin/BulkTransactions.participantList') ?></h4>
        <div class="overflow-x-auto bg-white rounded-lg shadow-md">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Contact</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">KTA / Birthdate</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Gender</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Validation Note</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php if (!empty($tempParticipants)): foreach ($tempParticipants as $p): ?>
                    <tr class="<?= $p->process_status === 'Invalid' ? 'bg-red-50 hover:bg-red-100' : 'hover:bg-gray-50' ?>">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                            <?= esc($p->name) ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div><?= esc($p->email) ?></div>
                            <div class="text-xs"><?= esc($p->phone_number) ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div><?= esc($p->kta_number) ?></div>
                            <?php if($p->birth_date): ?>
                                <div class="text-xs"><?= date('d M Y', strtotime($p->birth_date)) ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <?= esc($p->gender) ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <?php 
                                $statusClass = 'bg-gray-100 text-gray-800'; // Default for Processing
                                if ($p->process_status === 'Valid') $statusClass = 'bg-green-100 text-green-800';
                                if ($p->process_status === 'Invalid') $statusClass = 'bg-red-100 text-red-800';
                            ?>
                            <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?= $statusClass ?>">
                                <?= esc($p->process_status) ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-xs text-red-700">
                            <?= esc($p->process_result) ?>
                        </td>
                    </tr>
                    <?php endforeach; else: ?>
                    <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500">No temporary participant data found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?= $this->endSection() ?>