<?= csrf_field() ?>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div class="md:col-span-2">
        <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Churches.labelName') ?></label>
        <input type="text" name="name" id="name" value="<?= old('name', $church->name ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div>
        <label for="city" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Churches.labelCity') ?></label>
        <input type="text" name="city" id="city" value="<?= old('city', $church->city ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
    </div>
    <div>
        <label for="region" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Churches.labelRegion') ?></label>
        <input type="text" name="region" id="region" value="<?= old('region', $church->region ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
    </div>
    <div>
        <label for="sort_order" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Churches.labelSortOrder') ?></label>
        <input type="number" name="sort_order" id="sort_order" value="<?= old('sort_order', $church->sort_order ?? '10') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
        <p class="..."><?= lang('Admin/Churches.sortOrderHelp') ?></p>
    </div>
    <div>
        <label for="is_gka" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Churches.labelIsGka') ?></label>
        <select name="is_gka" id="is_gka" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
            <option value="1" <?= (old('is_gka', $church->is_gka ?? '0') == '1') ? 'selected' : '' ?>>Yes</option>
            <option value="0" <?= (old('is_gka', $church->is_gka ?? '0') == '0') ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="md:col-span-2">
        <label class="flex items-center">
            <input type="checkbox" name="is_active" value="1" class="h-4 w-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500" <?= old('is_active', $church->is_active ?? true) ? 'checked' : '' ?>>
            <span class="ml-2 block text-sm font-medium text-gray-900"><?= lang('Admin/Churches.labelIsActive') ?></span>
        </label>
    </div>
</div>