<?= $this->extend('backend/layouts/main') ?>
<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold"><?= lang('Admin/Churches.pageHeader') ?></h2>
        <a href="<?= route_to('admin.churches.new') ?>" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700"><?= lang('Admin/Churches.btnNew') ?></a>
    </div>
    <?= $this->include('backend/layouts/_notifications') ?>
    <div class="overflow-x-auto bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Churches.colName') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Churches.colCity') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Churches.colRegion') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Churches.colType') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Churches.colStatus') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Churches.colActions') ?></th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if (!empty($churches)): foreach ($churches as $church): ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?= esc($church->name) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($church->city) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($church->region) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= $church->is_gka ? lang('Admin/Churches.typeGKA') : lang('Admin/Churches.typeOther') ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 text-xs rounded-full <?= $church->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
                                <?= $church->is_active ? lang('Admin/Churches.statusActive') : lang('Admin/Churches.statusInactive') ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <a href="<?= route_to('admin.churches.edit', $church->id) ?>" class="text-indigo-600 hover:underline">Edit</a>
                        </td>
                    </tr>
                <?php endforeach; else: ?>
                    <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500"><?= lang('Admin/Churches.noResults') ?></td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="mt-6"><?= $pager->links('default', 'tailwind') ?></div>
<?= $this->endSection() ?>