<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div class="md:col-span-2">
        <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelName') ?></label>
        <input type="text" name="name" id="name" value="<?= old('name', $event->name ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div>
        <label for="event_code" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelCode') ?></label>
        <input type="text" name="event_code" id="event_code" value="<?= old('event_code', $event->event_code ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div>
        <label for="church_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelChurch') ?></label>
        <select name="church_id" id="church_id" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
            <option value="">-- For All Churches --</option>
            <?php foreach($churches as $church): ?>
                <option value="<?= $church->id ?>" <?= (old('church_id', $event->church_id ?? '') == $church->id) ? 'selected' : '' ?>><?= esc($church->name) ?></option>
            <?php endforeach; ?>
        </select>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.churchHelp') ?></p>
    </div>
    <div class="md:col-span-2">
        <label for="thumbnail" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelThumbnail') ?></label>
        <input type="file" name="thumbnail" id="thumbnail" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.thumbHelp') ?></p>
        <?php if (isset($event) && $event->thumbnail): ?>
            <img src="<?= base_url('uploads/thumbnails/' . $event->thumbnail) ?>" class="mt-2 h-24 rounded shadow-sm">
        <?php endif; ?>
    </div>
    <div class="md:col-span-2">
        <label for="description" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelDesc') ?></label>
        <textarea name="description" id="description" rows="5" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5"><?= old('description', $event->description ?? '') ?></textarea>
    </div>
    <div>
        <label for="start_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelStartDate') ?></label>
        <input type="date" name="start_date" id="start_date" value="<?= old('start_date', $event->start_date ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div>
        <label for="end_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelEndDate') ?></label>
        <input type="date" name="end_date" id="end_date" value="<?= old('end_date', $event->end_date ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div class="md:col-span-2">
        <label for="invoice_format" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelInvoice') ?></label>
        <input type="text" name="invoice_format" id="invoice_format" value="<?= old('invoice_format', $event->invoice_format ?? 'INV/{YYYY}{MM}/[SEQ:5]') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.invoiceHelp') ?></p>
    </div>
    <div class="md:col-span-2">
        <label for="terms_conditions" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelTerms') ?></label>
        <textarea name="terms_conditions" id="terms_conditions" rows="5" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5"><?= old('terms_conditions', $event->terms_conditions ?? '') ?></textarea>
    </div>
    <div>
        <label for="quota" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelQuota') ?></label>
        <input type="number" name="quota" id="quota" value="<?= old('quota', $event->quota ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.quotaHelp') ?></p>
    </div>
    <div class="flex items-end pb-2">
        <div class="flex items-center">
            <input id="is_active" name="is_active" type="checkbox" value="1" class="h-4 w-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500" <?= old('is_active', $event->is_active ?? 0) == 1 ? 'checked' : '' ?>>
            <label for="is_active" class="ml-2 block text-sm font-medium text-gray-900"><?= lang('Admin/Events.labelActive') ?></label>
        </div>
    </div>
</div>