<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold"><?= lang('Admin/Events.pageHeader') ?></h2>
        <a href="<?= route_to('admin.events.new') ?>" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 shadow-sm"><?= lang('Admin/Events.btnNew') ?></a>
    </div>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <div class="overflow-x-auto bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Events.colEvent') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Events.colChurch') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Events.colDates') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Events.colStatus') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Events.colActions') ?></th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if (!empty($events)): foreach($events as $event): ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?= esc($event->name) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($event->church_name ?? lang('Admin/Events.allChurches')) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= date('d M Y', strtotime($event->start_date)) ?> - <?= date('d M Y', strtotime($event->end_date)) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <?= $event->is_active ? '<span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">'.lang('Admin/Events.statusActive').'</span>' : '<span class="px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">'.lang('Admin/Events.statusInactive').'</span>' ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <a href="<?= route_to('admin.events.show', $event->id) ?>" class="text-indigo-600 hover:underline"><?= lang('Admin/Events.btnManage') ?></a>
                        </td>
                    </tr>
                <?php endforeach; else: ?>
                    <tr><td colspan="5" class="px-6 py-4 text-center text-gray-500"><?= lang('Admin/Events.noResults') ?></td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="mt-6"><?= $pager->links('default', 'tailwind') ?></div>
<?= $this->endSection() ?>