<?= csrf_field() ?>
<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div class="md:col-span-2">
        <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelName') ?></label>
        <input type="text" name="name" id="name" value="<?= old('name', $package->name ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div>
        <label for="start_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelStartDate') ?></label>
        <input type="date" name="start_date" id="start_date" value="<?= old('start_date', $package->start_date ?? $event->start_date) ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div>
        <label for="end_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelEndDate') ?></label>
        <input type="date" name="end_date" id="end_date" value="<?= old('end_date', $package->end_date ?? $event->end_date) ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
    </div>
    <div>
        <label for="price" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelPrice') ?></label>
        <input type="number" name="price" id="price" value="<?= old('price', $package->price ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required min="0">
    </div>
    <div>
        <label for="quota" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelQuota') ?></label>
        <input type="number" name="quota" id="quota" value="<?= old('quota', $package->quota ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" min="0">
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Events.pkgLabelQuotaHelp') ?></p>
    </div>
    <div>
        <label for="require_kta" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelRequireKta') ?></label>
        <select name="require_kta" id="require_kta" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
            <option value="0" <?= (old('require_kta', $package->require_kta ?? '0') == '0') ? 'selected' : '' ?>><?= lang('Admin/Events.optionNo') ?></option>
            <option value="1" <?= (old('require_kta', $package->require_kta ?? '0') == '1') ? 'selected' : '' ?>><?= lang('Admin/Events.optionYes') ?></option>
        </select>
    </div>
    <div>
        <label for="include_meal" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelMeal') ?></label>
        <select name="include_meal" id="include_meal" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
            <option value="0" <?= (old('include_meal', $package->include_meal ?? '0') == '0') ? 'selected' : '' ?>><?= lang('Admin/Events.optionNo') ?></option>
            <option value="1" <?= (old('include_meal', $package->include_meal ?? '0') == '1') ? 'selected' : '' ?>><?= lang('Admin/Events.optionYes') ?></option>
        </select>
    </div>
    <div class="md:col-span-2">
        <label for="gender_rule" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Events.pkgLabelGender') ?></label>
        <select name="gender_rule" id="gender_rule" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
            <option value="All" <?= (old('gender_rule', $package->gender_rule ?? 'All') == 'All') ? 'selected' : '' ?>><?= lang('Admin/Events.optionAllGenders') ?></option>
            <option value="Male" <?= (old('gender_rule', $package->gender_rule ?? 'All') == 'Male') ? 'selected' : '' ?>><?= lang('Admin/Events.optionMaleOnly') ?></option>
            <option value="Female" <?= (old('gender_rule', $package->gender_rule ?? 'All') == 'Female') ? 'selected' : '' ?>><?= lang('Admin/Events.optionFemaleOnly') ?></option>
        </select>
    </div>
</div>