<?= csrf_field() ?>
<div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4" x-data="{ discountType: '<?= old('discount_type', (isset($promotion) && $promotion->discount_amount > 0 ? 'fixed' : 'percent')) ?>' }">
    
    <!-- Event -->
    <div class="md:col-span-2">
        <label for="event_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelEvent') ?></label>
        <select name="event_id" id="event_id" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required>
            <option value="">-- Select Event --</option>
            <?php foreach($events as $event): ?>
                <option value="<?= $event->id ?>" <?= (old('event_id', $promotion->event_id ?? '') == $event->id) ? 'selected' : '' ?>><?= esc($event->name) ?></option>
            <?php endforeach; ?>
        </select>
    </div>

    <!-- Nama & Kode Promo -->
    <div>
        <label for="name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelName') ?></label>
        <input type="text" name="name" id="name" value="<?= old('name', $promotion->name ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Promotions.nameHelp') ?></p>
    </div>
    <div>
        <label for="code" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelCode') ?></label>
        <input type="text" name="code" id="code" value="<?= old('code', $promotion->code ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5 uppercase" required>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Promotions.codeHelp') ?></p>
    </div>

    <!-- Deskripsi -->
    <div class="md:col-span-2">
        <label for="description" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelDesc') ?></label>
        <textarea name="description" id="description" rows="3" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5"><?= old('description', $promotion->description ?? '') ?></textarea>
    </div>

    <hr class="md:col-span-2 my-4">

    <!-- Batasan Kuantitas & Kuota -->
    <div>
        <label for="min_quantity" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelMinQty') ?></label>
        <input type="number" name="min_quantity" id="min_quantity" value="<?= old('min_quantity', $promotion->min_quantity ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required min="0">
    </div>
    <div>
        <label for="max_quantity" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelMaxQty') ?></label>
        <input type="number" name="max_quantity" id="max_quantity" value="<?= old('max_quantity', $promotion->max_quantity ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" min="0">
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Promotions.qtyHelp') ?></p>
    </div>
    <div class="md:col-span-2">
        <label for="quota" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelQuota') ?></label>
        <input type="number" name="quota" id="quota" value="<?= old('quota', $promotion->quota ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required min="0">
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Promotions.quotaHelp') ?></p>
    </div>

    <hr class="md:col-span-2 my-4">
    
    <!-- Batasan Nominal -->
    <div>
        <label for="min_amount" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelMinAmount') ?></label>
        <input type="number" name="min_amount" id="min_amount" value="<?= old('min_amount', $promotion->min_amount ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required min="0">
    </div>
    <div>
        <label for="max_amount" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelMaxAmount') ?></label>
        <input type="number" name="max_amount" id="max_amount" value="<?= old('max_amount', $promotion->max_amount ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" min="0">
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Promotions.amountHelp') ?></p>
    </div>

    <hr class="md:col-span-2 my-4">

    <!-- Tipe & Nilai Diskon -->
    <div class="md:col-span-2">
        <label class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelDiscountType') ?></label>
        <div class="mt-2 flex gap-6">
            <label class="flex items-center"><input type="radio" name="discount_type" value="fixed" x-model="discountType" class="h-4 w-4 text-indigo-600 border-gray-300"> <span class="ml-2"><?= lang('Admin/Promotions.typeFixed') ?></span></label>
            <label class="flex items-center"><input type="radio" name="discount_type" value="percent" x-model="discountType" class="h-4 w-4 text-indigo-600 border-gray-300"> <span class="ml-2"><?= lang('Admin/Promotions.typePercent') ?></span></label>
        </div>
    </div>
    <div x-show="discountType === 'fixed'" x-cloak>
        <label for="discount_amount" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelDiscountAmount') ?></label>
        <input type="number" name="discount_amount" value="<?= old('discount_amount', $promotion->discount_amount ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" min="0">
    </div>
    <div x-show="discountType === 'percent'" x-cloak>
        <label for="discount_percent" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelDiscountPercent') ?></label>
        <input type="number" name="discount_percent" value="<?= old('discount_percent', $promotion->discount_percent ?? '0') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" min="0" max="100">
    </div>
    
    <hr class="md:col-span-2 my-4">

    <!-- Tanggal & Status -->
    <div>
        <label for="start_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelStartDate') ?></label>
        <input type="date" name="start_date" id="start_date" value="<?= old('start_date', $promotion->start_date ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required>
    </div>
    <div>
        <label for="end_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelEndDate') ?></label>
        <input type="date" name="end_date" id="end_date" value="<?= old('end_date', $promotion->end_date ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg block w-full p-2.5" required>
    </div>
    <div class="md:col-span-2">
        <label class="flex items-center mt-2">
            <input type="checkbox" name="is_active" value="1" class="h-4 w-4 text-indigo-600 border-gray-300 rounded" <?= old('is_active', $promotion->is_active ?? true) ? 'checked' : '' ?>>
            <span class="ml-2 text-sm font-medium text-gray-900"><?= lang('Admin/Promotions.labelIsActive') ?></span>
        </label>
    </div>
</div>