<?= $this->extend('frontend/layouts/main') ?>
<?= $this->section('pageTitle') ?><?= lang('Forgot.resetPassword') ?><?= $this->endSection() ?>
<?= $this->section('mainContent') ?>
<div class="flex items-center justify-center min-h-[calc(100vh-150px)]">
    <div class="w-full max-w-md p-8 space-y-6 bg-white rounded-lg shadow-md">
        <h1 class="text-2xl font-bold text-center text-gray-800"><?= lang('Forgot.resetPassword') ?></h1>
        <p class="text-center text-gray-600"><?= lang('Forgot.enterNewPassword') ?></p>
        
        <?= $this->include('frontend/components/_notifications') ?>

        <?= form_open(route_to('reset.process')) ?>
            <?= csrf_field() ?>
            <input type="hidden" name="token" value="<?= esc($token) ?>">
            <div class="space-y-4">
                <div>
                    <label for="password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Forgot.labelNewPass') ?></label>
                    <input type="password" name="password" id="password" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                </div>
                <div>
                    <label for="password_confirm" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Forgot.labelConfirmPass') ?></label>
                    <input type="password" name="password_confirm" id="password_confirm" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                </div>
            </div>
            <div class="pt-6">
                <button type="submit" class="w-full text-white bg-indigo-600 hover:bg-indigo-700 focus:ring-4 focus:outline-none focus:ring-indigo-300 font-medium rounded-lg text-sm px-5 py-3 text-center"><?= lang('Forgot.btnResetPassword') ?></button>
            </div>
        <?= form_close() ?>
    </div>
</div>
<?= $this->endSection() ?>