<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('pageTitle') ?><?= lang('Dashboard.pageTitle') ?><?= $this->endSection() ?>

<?= $this->section('mainContent') ?>
<div class="container mx-auto px-4 py-8">
    <div class="flex flex-col sm:flex-row justify-between items-start gap-4 mb-8">
        <div>
            <h1 class="text-3xl font-bold text-gray-800"><?= lang('Dashboard.welcome') ?> <?= esc($userName) ?>!</h1>
            <p class="text-gray-600 mt-1"><?= lang('Dashboard.subHeading') ?></p>
        </div>
        <div>
            <a href="<?= route_to('transaction.new') ?>" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:border-indigo-900 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                <?= lang('Dashboard.buttonNew') ?>
            </a>
        </div>
    </div>

    <div class="bg-white p-6 rounded-lg shadow-md">
        <h2 class="text-xl font-semibold mb-4 text-gray-700"><?= lang('Dashboard.transactionsTitle') ?></h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Dashboard.tableInvoice') ?></th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Dashboard.tableDate') ?></th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Dashboard.tableAmount') ?></th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Dashboard.tableStatus') ?></th>
                        <th scope="col" class="relative px-6 py-3">
                            <span class="sr-only"><?= lang('Dashboard.tableActions') ?></span>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php if (!empty($transactions)): ?>
                        <?php foreach ($transactions as $transaction): ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    <?= esc($transaction->invoice_number) ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?= esc(date('d M Y, H:i', strtotime($transaction->created_at))) ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    Rp <?= number_format(esc($transaction->total_amount), 0, ',', '.') ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <?php
                                        // CORRECTED: Use object syntax ->
                                        $statusClass = '';
                                        $statusText = ucfirst(esc($transaction->payment_status));
                                        switch ($transaction->payment_status) {
                                            case 'paid': 
                                                $statusClass = 'bg-green-100 text-green-800';
                                                $statusText = lang('Dashboard.statusPaid');
                                                break;
                                            case 'canceled':
                                                $statusClass = 'bg-red-100 text-red-800';
                                                $statusText = lang('Dashboard.statusCanceled');
                                                break;
                                            case 'rejected':
                                                $statusClass = 'bg-red-100 text-red-800';
                                                $statusText = lang('Dashboard.statusRejected');
                                                break;
                                            default: // 'pending' or any other status
                                                $statusClass = 'bg-yellow-100 text-yellow-800';
                                                $statusText = lang('Dashboard.statusPending');
                                        }
                                    ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?= $statusClass ?>">
                                        <?= $statusText ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="<?= route_to('transaction.show', $transaction->uuid) ?>" class="text-indigo-600 hover:text-indigo-900"><?= lang('Dashboard.viewDetails') ?></a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-500">
                                <?= lang('Dashboard.noTransactions') ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->endSection() ?>