<?php
// File: app/Filters/GuestFilter.php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class GuestFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $type = $arguments[0] ?? 'user';

        if (session()->get('isLoggedIn')) {
            if ($type === 'admin' && session()->get('user_type') === 'admin') {
                return redirect()->to(route_to('admin.dashboard'));
            }
            
            if ($type === 'user' && session()->get('user_type') === 'user') {
                return redirect()->to(route_to('dashboard.show'));
            }
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do nothing
    }
}