<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('pageTitle') ?><?= lang('Login.pageTitle') ?><?= $this->endSection() ?>

<?= $this->section('mainContent') ?>
<div class="flex items-center justify-center min-h-[calc(100vh-150px)]">
    <div class="w-full max-w-md p-8 space-y-6 bg-white rounded-lg shadow-md">
        <h1 class="text-3xl font-bold text-center text-gray-800"><?= lang('Login.mainHeading') ?></h1>
        <p class="text-center text-gray-600"><?= lang('Login.subHeading') ?></p>
        
        <!-- Menampilkan notifikasi -->
        <?= $this->include('frontend/components/_notifications') ?>

        <?= form_open(route_to('login.attempt')) ?>
        <?= csrf_field() ?>

        <div class="space-y-4">
            <!-- Email -->
            <div>
                <label for="email" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Login.labelEmail') ?></label>
                <input type="email" name="email" id="email" class="bg-gray-50 border <?= service('validation')->hasError('email') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" placeholder="<?= lang('Login.placeholderEmail') ?>" value="<?= old('email') ?>" required>
                <?php if (service('validation')->hasError('email')): ?>
                    <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('email') ?></p>
                <?php endif ?>
            </div>

            <!-- Password -->
            <div>
                <label for="password" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Login.labelPassword') ?></label>
                <input type="password" name="password" id="password" class="bg-gray-50 border <?= service('validation')->hasError('password') ? 'border-red-500' : 'border-gray-300' ?> text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" required>
                 <?php if (service('validation')->hasError('password')): ?>
                    <p class="mt-1 text-xs text-red-600"><?= service('validation')->getError('password') ?></p>
                <?php endif ?>
            </div>
        </div>

        <div class="flex items-center justify-between mt-6">
            <a href="<?= route_to('forgot.form') ?>" class="text-sm text-indigo-600 hover:underline"><?= lang('Login.forgotPassword') ?></a>
        </div>

        <div class="pt-6">
             <button type="submit" class="w-full text-white bg-indigo-600 hover:bg-indigo-700 focus:ring-4 focus:outline-none focus:ring-indigo-300 font-medium rounded-lg text-sm px-5 py-3 text-center"><?= lang('Login.buttonLogin') ?></button>
        </div>
       
        <p class="text-sm font-light text-gray-500 text-center">
            <?= lang('Login.registerLinkText') ?> <a href="<?= route_to('register.show') ?>" class="font-medium text-indigo-600 hover:underline"><?= lang('Login.registerLink') ?></a>
        </p>
        
        <?= form_close() ?>
    </div>
</div>
<?= $this->endSection() ?>