<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Admins.labelName') ?></label>
        <input type="text" name="name" id="name" value="<?= old('name', $admin->name ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" required>
    </div>
    <div>
        <label for="email" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Admins.labelEmail') ?></label>
        <input type="email" name="email" id="email" value="<?= old('email', $admin->email ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" required>
    </div>
    <div>
        <label for="password" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Admins.labelPassword') ?></label>
        <input type="password" name="password" id="password" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" <?= isset($admin) ? '' : 'required' ?>>
        <?php if(isset($admin)): ?><p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Admins.passHelp') ?></p><?php endif; ?>
    </div>
    <div>
        <label for="password_confirm" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Admins.labelConfirmPass') ?></label>
        <input type="password" name="password_confirm" id="password_confirm" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" <?= isset($admin) ? '' : 'required' ?>>
    </div>
    <div class="md:col-span-2">
        <label for="role_id" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Admins.labelRole') ?></label>
        <select name="role_id" id="role_id" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" required>
            <option value="">-- Select Role --</option>
            <?php foreach($roles as $role): ?>
                <option value="<?= $role->id ?>" <?= (old('role_id', $currentRole ?? '') == $role->id) ? 'selected' : '' ?>><?= esc($role->name) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="md:col-span-2">
        <label for="church_ids" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Admins.labelChurches') ?></label>
        <select name="church_ids[]" id="church_ids" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" multiple size="8">
            <?php $selectedChurches = old('church_ids', $currentChurches ?? []); ?>
            <?php foreach($churches as $church): ?>
                <option value="<?= $church->id ?>" <?= in_array($church->id, $selectedChurches) ? 'selected' : '' ?>><?= esc($church->name) ?></option>
            <?php endforeach; ?>
        </select>
        <p class="text-xs text-gray-500 mt-1"><?= lang('Admin/Admins.churchHelp') ?></p>
    </div>
</div>