<div x-data="{
    checkAll: false,
    toggleAll() {
        this.checkAll = !this.checkAll;
        let checkboxes = document.querySelectorAll('.permission-check');
        checkboxes.forEach(c => c.checked = this.checkAll);
    }
}">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="md:col-span-2">
            <label for="name" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Roles.labelName') ?></label>
            <input type="text" name="name" id="name" value="<?= old('name', $role->name ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2" required>
        </div>
        <div class="md:col-span-2">
            <label for="description" class="block text-sm font-medium text-gray-700"><?= lang('Admin/Roles.labelDesc') ?></label>
            <textarea name="description" id="description" rows="3" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2"><?= old('description', $role->description ?? '') ?></textarea>
        </div>
    </div>

    <hr class="my-6">

    <div class="space-y-4">
        <h4 class="text-lg font-semibold text-gray-800"><?= lang('Admin/Roles.labelPerms') ?></h4>
        <div class="flex items-center">
            <input id="select-all" type="checkbox" @click="toggleAll()" class="h-4 w-4 text-indigo-600 border-gray-300 rounded">
            <label for="select-all" class="ml-2 block text-sm text-gray-900 font-medium"><?= lang('Admin/Roles.select_all') ?></label>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
            <?php foreach($permissions as $permission): ?>
                <div class="relative flex items-start">
                    <div class="flex h-5 items-center">
                        <input id="permission_<?= $permission->id ?>" name="permissions[]" value="<?= $permission->id ?>" type="checkbox" class="permission-check h-4 w-4 text-indigo-600 border-gray-300 rounded" <?= in_array($permission->id, old('permissions', $currentPermissions ?? [])) ? 'checked' : '' ?>>
                    </div>
                    <div class="ml-3 text-sm">
                        <label for="permission_<?= $permission->id ?>" class="font-medium text-gray-700"><?= esc($permission->name) ?></label>
                        <p class="text-gray-500"><?= esc($permission->description) ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>