<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold"><?= lang('Admin/Roles.pageHeader') ?></h2>
        <?php if(has_permission('create-role')): ?>
            <a href="<?= route_to('admin.roles.new') ?>" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700"><?= lang('Admin/Roles.btnNew') ?></a>
        <?php endif; ?>
    </div>
    
    <?= $this->include('backend/layouts/_notifications') ?>

    <div class="overflow-x-auto bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Roles.colRoleName') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Roles.colDescription') ?></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><?= lang('Admin/Roles.colActions') ?></th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php foreach($roles as $role): ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?= esc($role->name) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($role->description) ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <?php if(has_permission('edit-role')): ?>
                                <a href="<?= route_to('admin.roles.edit', $role->id) ?>" class="text-indigo-600 hover:underline">Edit</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="mt-6"><?= $pager->links('default', 'tailwind') ?></div>
<?= $this->endSection() ?>