<?= $this->extend('frontend/layouts/main') ?>
<?= $this->section('pageTitle') ?><?= lang('Forgot.forgotPassword') ?><?= $this->endSection() ?>
<?= $this->section('mainContent') ?>
<div class="flex items-center justify-center min-h-[calc(100vh-150px)]">
    <div class="w-full max-w-md p-8 space-y-6 bg-white rounded-lg shadow-md">
        <h1 class="text-2xl font-bold text-center text-gray-800"><?= lang('Forgot.forgotPassword') ?></h1>
        <p class="text-center text-gray-600"><?= lang('Forgot.enterEmail') ?></p>
        
        <?= $this->include('frontend/components/_notifications') ?>

        <?= form_open(route_to('forgot.send')) ?>
            <?= csrf_field() ?>
            <div>
                <label for="email" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Forgot.labelEmail') ?></label>
                <input type="email" name="email" id="email" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5" value="<?= old('email') ?>" required>
            </div>
            <div class="pt-6">
                <button type="submit" class="w-full text-white bg-indigo-600 hover:bg-indigo-700 focus:ring-4 focus:outline-none focus:ring-indigo-300 font-medium rounded-lg text-sm px-5 py-3 text-center"><?= lang('Forgot.btnSendLink') ?></button>
            </div>
        <?= form_close() ?>
        <p class="text-sm text-center">
            <a href="<?= route_to('login.show') ?>" class="font-medium text-indigo-600 hover:underline"><?= lang('Forgot.backToLogin') ?></a>
        </p>
    </div>
</div>
<?= $this->endSection() ?>