<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title><?= lang('Transaction.pdf_eticket_title', [esc($transaction->invoice_number)]) ?></title>
    <style>
        body { font-family: sans-serif; color: #333; font-size: 12px; }
        .container { max-width: 700px; margin: auto; }
        .header { text-align: center; border-bottom: 2px solid #eee; padding-bottom: 10px; margin-bottom: 20px;}
        .header h1 { color: #4f46e5; margin: 0; font-size: 24px;}
        .header p { margin: 5px 0 0 0; }
        .details-table { width: 100%; margin-bottom: 20px; border-collapse: collapse; }
        .details-table td { padding: 5px 0; }
        h3 { font-size: 16px; border-bottom: 1px solid #ccc; padding-bottom: 5px; }
        .ticket { border: 1px solid #ddd; border-radius: 5px; padding: 15px; margin-bottom: 15px; page-break-inside: avoid; }
        .ticket h4 { margin-top: 0; font-size: 14px; }
        .qr-code { text-align: center; margin: 15px 0; }
        .qr-string { font-size: 1.2em; letter-spacing: 2px; font-family: monospace; color: #4f46e5; text-align: center; }
        hr { border: none; border-top: 1px solid #eee; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?= lang('Transaction.pdf_eticket_heading') ?></h1>
            <p><?= lang('Transaction.pdf_invoice_label') ?>: <strong><?= esc($transaction->invoice_number) ?></strong></p>
        </div>

        <h3><?= lang('Transaction.pdf_transaction_details') ?></h3>
        <table class="details-table">
            <tr>
                <td width="150px"><strong><?= lang('Transaction.pdf_event_label') ?></strong></td>
                <td><?= esc($event->name) ?></td>
            </tr>
            <tr>
                <td><strong><?= lang('Transaction.pdf_date_label') ?></strong></td>
                <td><?= date('d M Y, H:i', strtotime($transaction->created_at)) ?></td>
            </tr>
            <tr>
                <td><strong><?= lang('Transaction.pdf_amount_label') ?></strong></td>
                <td>Rp <?= number_format($transaction->total_amount, 0, ',', '.') ?></td>
            </tr>
            <tr>
                <td><strong><?= lang('Transaction.pdf_status_label') ?></strong></td>
                <td style="color: #16a34a; font-weight: bold;"><?= esc(ucfirst($transaction->payment_status)) ?></td>
            </tr>
        </table>
        
        <h3><?= lang('Transaction.pdf_participant_tickets') ?></h3>
        <?php foreach($participants as $p): ?>
            <div class="ticket">
                <h4><?= esc($p->name) ?></h4>
                <small><?= esc($p->email) ?> | <?= esc($p->phone_number) ?> | <?= esc($p->phone_number) ?> | 
                    <?php
                        $churchName = $p->joined_church_name ?: $p->church_name;
                        echo esc($churchName ?: 'No Church Data'); 
                    ?>
                </small>
                
                <?php if (!empty($p->qr_image_path)): ?>
                    <div class="qr-code">
                        <?php
                            $path = WRITEPATH . 'qrcodes/' . $p->qr_image_path;
                            if (file_exists($path)) {
                                $type = pathinfo($path, PATHINFO_EXTENSION);
                                $data = file_get_contents($path);
                                $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                                echo '<img src="' . $base64 . '" width="150" alt="QR Code">';
                            }
                        ?>
                    </div>
                    <p class="qr-string"><?= esc($p->qr_number) ?></p>
                <?php else: ?>
                    <p style="color: red; text-align: center; margin: 15px 0;"><?= lang('Transaction.pdf_qr_not_available') ?></p>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
</body>
</html>