<?php

namespace App\Models;

use CodeIgniter\Model;

class ChurchModel extends Model
{
    protected $table            = 'churches';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;

    protected $allowedFields = ['name', 'city', 'region', 'is_gka', 'is_active'];

    protected $useTimestamps    = false;

    protected $validationRules = [
        'name'      => 'required|max_length[150]|is_unique[churches.name,id,{id}]',
        'city'      => 'permit_empty|max_length[100]',
        'region'    => 'permit_empty|max_length[100]',
        'is_active' => 'in_list[0,1]',
    ];
}