<?php

namespace App\Models;

use CodeIgniter\Model;

class EventModel extends Model
{
    protected $table            = 'events';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = true;

    protected $allowedFields    = [
        'church_id',
        'name',
        'event_code',       // <-- TAMBAHKAN
        'slug',             // <-- TAMBAHKAN
        'thumbnail',
        'description',
        'start_date',
        'end_date',
        'is_active',
        'invoice_format'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Callbacks untuk membuat slug otomatis
    protected $beforeInsert = ['generateSlug'];
    protected $beforeUpdate = ['generateSlug'];

    // Validation
    protected $validationRules = [
        'name'           => 'required|max_length[150]',
        'event_code'     => 'permit_empty|max_length[50]|is_unique[events.event_code,id,{id}]', // <-- TAMBAHKAN
        'slug'           => 'required|max_length[200]|is_unique[events.slug,id,{id}]',      // <-- TAMBAHKAN
        'start_date'     => 'required|valid_date',
        'end_date'       => 'required|valid_date',
        'is_active'      => 'in_list[0,1]',
        'invoice_format' => 'permit_empty|max_length[100]',
    ];

    /**
     * Callback untuk membuat slug secara otomatis dari 'name' field.
     * Dipanggil sebelum data disimpan (insert/update).
     */
    protected function generateSlug(array $data): array
    {
        // Jika data yang dikirim sudah memiliki slug, atau tidak ada 'name', lewati.
        if (isset($data['data']['slug']) && !empty($data['data']['slug'])) {
            // Pastikan slug yang ada tetap URL-friendly
            $data['data']['slug'] = url_title($data['data']['slug'], '-', true);
            return $data;
        }

        // Jika tidak ada slug tapi ada 'name', buat slug dari 'name'.
        if (isset($data['data']['name'])) {
            $slug = url_title($data['data']['name'], '-', true); // Helper URL CodeIgniter

            // Cek apakah slug sudah ada, jika ya, tambahkan suffix unik
            $existing = $this->where('slug', $slug)->first();
            if ($existing) {
                // Jika slug ditemukan pada item lain (bukan item yang sedang di-update)
                $currentId = $data['id'][0] ?? null;
                if (!$currentId || $currentId != $existing->id) {
                     $slug = $slug . '-' . time(); // Tambahkan timestamp untuk keunikan
                }
            }
            $data['data']['slug'] = $slug;
        }

        return $data;
    }
}