<?php

namespace App\Models;

use CodeIgniter\Model;

class EventPackageModel extends Model
{
    protected $table            = 'event_packages';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = true;

    protected $allowedFields    = [
        'event_id', 
        'name', 
        'start_date', 
        'end_date', 
        'price', 
        'require_kta', 
        'include_meal', 
        'gender_rule'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules = [
        'event_id'    => 'required|is_natural_no_zero',
        'name'        => 'required|max_length[100]',
        'start_date'  => 'required|valid_date',
        'end_date'    => 'required|valid_date',
        'price'       => 'required|is_natural',
        'require_kta' => 'in_list[0,1]',
        'include_meal'=> 'in_list[0,1]',
        'gender_rule' => 'in_list[All,Male,Female]',
    ];
}