<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>

<!-- Form Filter -->
<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h4 class="text-xl font-semibold mb-4"><?= lang('Admin/ParticipantReport.filter') ?></h4>
    <form action="<?= current_url() ?>" method="get" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
        
        <div>
            <label for="name" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterName') ?></label>
            <input type="text" name="name" id="name" value="<?= esc($filters['name'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div>
            <label for="phone" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterPhone') ?></label>
            <input type="tel" name="phone" id="phone" value="<?= esc($filters['phone'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div>
            <label for="email" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterEmail') ?></label>
            <input type="email" name="email" id="email" value="<?= esc($filters['email'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div>
            <label for="church" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterChurch') ?></label>
            <input type="text" name="church" id="church" value="<?= esc($filters['church'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div>
            <label for="kta_number" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterKta') ?></label>
            <input type="text" name="kta_number" id="kta_number" value="<?= esc($filters['kta_number'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div>
            <label for="birth_date" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterBirthdate') ?></label>
            <input type="date" name="birth_date" id="birth_date" value="<?= esc($filters['birth_date'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>
        
        <div>
            <label for="event_id" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterEvent') ?></label>
            <select name="event_id" id="event_id" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
                <option value="">All Events</option>
                <?php foreach($events as $event): ?>
                    <option value="<?= $event->id ?>" <?= (($filters['event_id'] ?? '') == $event->id) ? 'selected' : '' ?>><?= esc($event->name) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="invoice_number" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterInvoice') ?></label>
            <input type="text" name="invoice_number" id="invoice_number" value="<?= esc($filters['invoice_number'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div>
            <label for="qr_number" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterQr') ?></label>
            <input type="text" name="qr_number" id="qr_number" value="<?= esc($filters['qr_number'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>
        
        <div>
            <label for="start_date" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterStartDate') ?></label>
            <input type="date" name="start_date" id="start_date" value="<?= esc($filters['start_date'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div>
            <label for="end_date" class="block text-sm font-medium text-gray-700"><?= lang('Admin/ParticipantReport.filterEndDate') ?></label>
            <input type="date" name="end_date" id="end_date" value="<?= esc($filters['end_date'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 border border-gray-300 rounded-md p-2">
        </div>

        <div class="col-span-full flex items-end gap-4 pt-4">
            <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 shadow-sm"><?= lang('Admin/ParticipantReport.btnFilter') ?></button>
            <a href="<?= route_to('admin.reports.participants') ?>" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-300 shadow-sm"><?= lang('Admin/ParticipantReport.btnReset') ?></a>
            
            <?php
                $exportQuery = http_build_query(array_filter($filters));
            ?>
            <a href="<?= route_to('admin.reports.participants_export') ?>?<?= $exportQuery ?>"
               class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 shadow-sm">
               <?= lang('Admin/ParticipantReport.btnExportExcel') ?>
            </a>
        </div>
    </form>
</div>


<!-- Tabel Data Peserta -->
<div class="overflow-x-auto bg-white rounded-lg shadow-md">
    <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/ParticipantReport.colName') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/ParticipantReport.colContact') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/ParticipantReport.colEvent') ?> / <?= lang('Admin/ParticipantReport.colPackage') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/ParticipantReport.colChurch') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/ParticipantReport.colRegDate') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/ParticipantReport.colActions') ?></th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            <?php if (!empty($participants)): ?>
                <?php foreach ($participants as $p): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?= esc($p->name) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?= esc($p->email) ?><br>
                        <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $p->phone_number) ?>" target="_blank" class="text-indigo-600 hover:underline"><?= esc($p->phone_number) ?></a>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?= esc($p->event_name) ?><br>
                        <span class="text-xs text-gray-400"><?= esc($p->package_name) ?></span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($p->church_db_name ?: $p->church_name) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= date('d M Y', strtotime($p->created_at)) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <?php if(!empty($p->transaction_uuid)): ?>
                            <a href="<?= route_to('admin.transactions.show', $p->transaction_uuid) ?>" class="text-gray-600 hover:underline" title="View Transaction">View Trx</a>
                        <?php endif; ?>
                        <?php if($p->payment_status === 'paid'): ?>
                            <a href="<?= route_to('admin.reports.participant_pdf', $p->id) ?>" class="text-red-600 hover:underline ml-2" title="Download E-Ticket">PDF</a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="6" class="px-6 py-4 text-center text-gray-500"><?= lang('Admin/ParticipantReport.noResults') ?></td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<div class="mt-6"><?= $pager->links('default', 'tailwind') ?></div>

<?= $this->endSection() ?>